/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.browser.internal;

import com.teamdev.jxbrowser.browser.internal.RenderProcess;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.rpc.RenderProcessId;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;

public final class RenderProcesses
extends CloseableImpl {
    private final List<RenderProcess> processes = new CopyOnWriteArrayList<RenderProcess>();

    @Override
    public void close() {
        this.processes.forEach(renderProcess -> {
            renderProcess.close();
            this.remove((RenderProcess)renderProcess);
        });
        super.close();
    }

    public Optional<RenderProcess> renderProcess(RenderProcessId renderProcessId) {
        for (RenderProcess renderProcess : this.processes) {
            if (!renderProcess.id().equals(renderProcessId)) continue;
            return Optional.of(renderProcess);
        }
        return Optional.empty();
    }

    public void add(RenderProcess renderProcess) {
        this.processes.add(renderProcess);
    }

    public void remove(RenderProcess renderProcess) {
        this.processes.remove(renderProcess);
    }
}

