/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.browser.internal;

import com.teamdev.jxbrowser.Closeable;
import com.teamdev.jxbrowser.browser.event.internal.WebDialogEvent;
import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.browser.internal.callback.PaintWebDialogCallback;
import com.teamdev.jxbrowser.browser.internal.callback.WebDialogCallback;
import com.teamdev.jxbrowser.browser.internal.rpc.GpuStub;
import com.teamdev.jxbrowser.browser.internal.rpc.PaintDialog;
import com.teamdev.jxbrowser.browser.internal.rpc.WebDialogStub;
import com.teamdev.jxbrowser.callback.Advisable;
import com.teamdev.jxbrowser.event.Observable;
import com.teamdev.jxbrowser.event.Observer;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.internal.rpc.ConnectionId;
import com.teamdev.jxbrowser.internal.rpc.ConnectionType;
import com.teamdev.jxbrowser.internal.rpc.LocalServiceConnection;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnection;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.internal.rpc.UniversalServiceConnection;
import com.teamdev.jxbrowser.internal.rpc.WebDialogId;
import com.teamdev.jxbrowser.internal.rpc.event.ConnectionCreated;
import com.teamdev.jxbrowser.internal.rpc.transport.Connection;
import com.teamdev.jxbrowser.internal.rpc.transport.ConnectionServer;
import java.util.Optional;
import java.util.Set;

public final class WebDialog
implements Advisable<WebDialogCallback>,
Observable<WebDialogEvent> {
    private final BrowserImpl browser;
    private final ConnectionServer connectionServer;
    private final UniversalServiceConnection rpc;
    private final WebDialogId id;
    private ServiceConnectionImpl<GpuStub> gpu;

    public WebDialog(BrowserImpl browser, WebDialogId id) {
        this.browser = browser;
        this.id = id;
        this.rpc = UniversalServiceConnection.with(browser.engine().connection()).and(new ServiceConnectionImpl<WebDialogStub>(id, browser.engine().connection(), WebDialogStub::new)).and(new LocalServiceConnection(Set.of(PaintWebDialogCallback.class), Set.of())).build();
        this.connectionServer = browser.engine().connectionServer();
        this.connectionServer.on(ConnectionCreated.class, this::onConnectionCreated);
        this.connectionServer.getConnection(ConnectionType.GPU).ifPresent(this::onGpuConnectionCreated);
    }

    private void onConnectionCreated(ConnectionCreated event) {
        if (event.connection().type().equals(ConnectionType.GPU)) {
            ConnectionId connectionId = event.connection().id();
            this.connectionServer.awaitConnection(connectionId).ifPresent(this::onGpuConnectionCreated);
        }
    }

    private void onGpuConnectionCreated(Connection connection) {
        this.gpu().ifPresent(Closeable::close);
        this.gpu = new ServiceConnectionImpl<GpuStub>(this.id, connection, GpuStub::new);
        this.gpu.set(PaintWebDialogCallback.class, params -> this.rpc.get(PaintWebDialogCallback.class).map(callback -> (PaintDialog.Response)callback.on(params)).orElse(PaintDialog.Response.getDefaultInstance()));
    }

    private Optional<ServiceConnection<GpuStub>> gpu() {
        return Optional.ofNullable(this.gpu);
    }

    public BrowserImpl browser() {
        return this.browser;
    }

    @Override
    public <E extends WebDialogEvent> Subscription on(Class<E> eventClass, Observer<E> observer) {
        return this.rpc.on(eventClass, observer);
    }

    @Override
    public <C extends WebDialogCallback> C set(Class<C> callbackClass, C callback) {
        return (C)((WebDialogCallback)this.rpc.set(callbackClass, callback));
    }

    @Override
    public <C extends WebDialogCallback> Optional<C> get(Class<C> callbackClass) {
        return this.rpc.get(callbackClass);
    }

    @Override
    public <C extends WebDialogCallback> C remove(Class<C> callbackClass) {
        return (C)((WebDialogCallback)this.rpc.remove(callbackClass));
    }
}

