/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.browser.internal.callback;

import com.teamdev.jxbrowser.annotation.Immutable;
import com.teamdev.jxbrowser.browser.internal.callback.BrowserWidgetAsyncCallback;
import com.teamdev.jxbrowser.browser.internal.rpc.ShowDropdown;
import com.teamdev.jxbrowser.callback.AsyncCallbackAction;
import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.internal.rpc.Protobuf;
import com.teamdev.jxbrowser.ui.Rect;
import com.teamdev.jxbrowser.ui.internal.rpc.DropdownItem;
import java.util.List;
import java.util.function.Consumer;

public interface ShowDropdownCallback
extends BrowserWidgetAsyncCallback<Params, Action> {

    public static final class Action
    extends AsyncCallbackAction<ShowDropdown.Response> {
        public Action(Consumer<ShowDropdown.Response> consumer) {
            super(consumer);
        }

        public void cancel() {
            this.send(ShowDropdown.Response.newBuilder().setCancel(Protobuf.empty()).build());
        }

        public void select(com.teamdev.jxbrowser.ui.internal.DropdownItem item) {
            Preconditions.checkArgument(!item.isOptgroup(), "The item cannot be optgroup", new Object[0]);
            Preconditions.checkArgument(item.isEnabled(), "The item must be enabled", new Object[0]);
            this.send(ShowDropdown.Response.newBuilder().setSelectItem((DropdownItem)item).build());
        }
    }

    public static interface Params {
        default public Rect bounds() {
            return ((ShowDropdown.Request)this).getBounds();
        }

        default public double scaleFactor() {
            return ((ShowDropdown.Request)this).getScaleFactor();
        }

        @Immutable
        default public List<com.teamdev.jxbrowser.ui.internal.DropdownItem> items() {
            return ((ShowDropdown.Request)this).getItems().getItemList().stream().map(item -> item).toList();
        }
    }
}

