/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.cache.internal;

import com.teamdev.jxbrowser.cache.HttpCache;
import com.teamdev.jxbrowser.cache.internal.rpc.HttpCacheStub;
import com.teamdev.jxbrowser.deps.com.google.protobuf.Empty;
import com.teamdev.jxbrowser.engine.internal.EngineImpl;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.internal.rpc.transport.RpcCallback;
import com.teamdev.jxbrowser.profile.internal.ProfileImpl;
import com.teamdev.jxbrowser.time.TimeRange;
import java.util.concurrent.CompletableFuture;

public final class HttpCacheImpl
extends CloseableImpl
implements HttpCache {
    private final ProfileImpl profile;
    private final ServiceConnectionImpl<HttpCacheStub> rpc;

    public HttpCacheImpl(ProfileImpl profile) {
        Preconditions.checkNotNull(profile);
        this.profile = profile;
        EngineImpl engine = profile.engine();
        this.rpc = new ServiceConnectionImpl<HttpCacheStub>(engine.id(), engine.connection(), HttpCacheStub::new);
    }

    @Override
    public ProfileImpl profile() {
        return this.profile;
    }

    @Override
    public CompletableFuture<Void> clear() {
        return this.clear(TimeRange.FULL);
    }

    @Override
    public CompletableFuture<Void> clear(TimeRange range) {
        this.checkNotClosed();
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.rpc.invokeAsync(this.rpc.stub()::clear, this.profile.clearProfileDataRequest(range), new RpcCallback<Empty>(){

            @Override
            public void onNext(Empty value) {
                future.complete(null);
            }

            @Override
            public void onError(Throwable ignored) {
                future.cancel(false);
            }
        });
        return future;
    }

    @Override
    public void close() {
        this.rpc.close();
        super.close();
    }
}

