/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.capture.internal;

import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.capture.CaptureSession;
import com.teamdev.jxbrowser.capture.CaptureSource;
import com.teamdev.jxbrowser.capture.internal.rpc.CaptureSessionStopped;
import com.teamdev.jxbrowser.capture.internal.rpc.CaptureSessionStub;
import com.teamdev.jxbrowser.deps.com.google.protobuf.BoolValue;
import com.teamdev.jxbrowser.event.Observer;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.IdMap;
import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.internal.rpc.CaptureSessionId;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.internal.rpc.stream.Interceptor;

public final class CaptureSessionImpl
extends CloseableImpl
implements CaptureSession {
    private static final IdMap<CaptureSessionId, CaptureSessionImpl> captures = new IdMap();
    private final CaptureSessionId captureId;
    private final CaptureSource source;
    private final ServiceConnectionImpl<CaptureSessionStub> rpc;

    public static CaptureSession of(CaptureSessionId id) {
        Preconditions.checkNotNull(id);
        return captures.find(id).orElseThrow(IllegalStateException::new);
    }

    CaptureSessionImpl(BrowserImpl browser, CaptureSessionId id, CaptureSource source) {
        Preconditions.checkNotNull(browser);
        this.captureId = id;
        this.source = source;
        this.rpc = new ServiceConnectionImpl<CaptureSessionStub>(id, browser.engine().connection(), CaptureSessionStub::new);
        captures.put(id, this);
        this.rpc.setEventInterceptor(CaptureSessionStopped.class, event -> {
            captures.remove(event.getCaptureId());
            browser.contentCaptureSessions().removeCaptureSession(event.getCaptureId());
            return Interceptor.Action.PROCEED;
        });
    }

    @Override
    public void stop() {
        this.checkNotClosed();
        this.rpc.invoke(this.rpc.stub()::stop, this.captureId);
    }

    @Override
    public CaptureSource source() {
        return this.source;
    }

    @Override
    public boolean isActive() {
        this.checkNotClosed();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::isActive, this.captureId)).getValue();
    }

    @Override
    public void close() {
        this.rpc.close();
        super.close();
    }

    @Override
    public <E extends com.teamdev.jxbrowser.capture.event.CaptureSessionStopped> Subscription on(Class<E> eventClass, Observer<E> observer) {
        return this.rpc.on(eventClass, observer);
    }
}

