/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.dom.internal;

import com.teamdev.jxbrowser.deps.com.google.protobuf.BoolValue;
import com.teamdev.jxbrowser.deps.com.google.protobuf.StringValue;
import com.teamdev.jxbrowser.dom.Element;
import com.teamdev.jxbrowser.dom.ElementAttributes;
import com.teamdev.jxbrowser.dom.internal.ElementAttributesImpl;
import com.teamdev.jxbrowser.dom.internal.NodeImpl;
import com.teamdev.jxbrowser.dom.internal.rpc.BlurRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.ElementStub;
import com.teamdev.jxbrowser.dom.internal.rpc.FocusRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.GetBoundingClientRectRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.GetInnerHtmlRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.GetInnerTextRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.GetOuterHtmlRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.NodeInfo;
import com.teamdev.jxbrowser.dom.internal.rpc.ScrollIntoViewRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.SetInnerHtmlRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.SetInnerTextRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.SetOuterHtmlRequest;
import com.teamdev.jxbrowser.frame.internal.DomContext;
import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.internal.rpc.transport.Connection;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.ui.Rect;

public class ElementImpl
extends NodeImpl
implements Element {
    private final ServiceConnectionImpl<ElementStub> rpc;
    private final ElementAttributesImpl attributes;

    public static ElementImpl newInstance(Connection connection, DomContext domContext, NodeInfo nodeInfo) {
        return new ElementImpl(connection, domContext, nodeInfo);
    }

    ElementImpl(Connection connection, DomContext domContext, NodeInfo nodeInfo) {
        super(connection, domContext, nodeInfo);
        this.rpc = new ServiceConnectionImpl<ElementStub>(nodeInfo.getNodeId(), connection, ElementStub::new);
        this.attributes = new ElementAttributesImpl(this, this.rpc, nodeInfo, domContext);
    }

    @Override
    public final ElementAttributes attributes() {
        this.checkNotClosed();
        return this.attributes;
    }

    @Override
    public final String innerHtml() {
        this.checkNotClosed();
        GetInnerHtmlRequest request = GetInnerHtmlRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).build();
        return ((StringValue)this.rpc.invoke(this.rpc.stub()::getInnerHtml, request)).getValue();
    }

    @Override
    public final boolean innerHtml(String html) {
        Preconditions.checkNotNull(html);
        this.checkNotClosed();
        SetInnerHtmlRequest request = SetInnerHtmlRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).setInnerHtml(html).build();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::setInnerHtml, request)).getValue();
    }

    @Override
    public final String outerHtml() {
        this.checkNotClosed();
        GetOuterHtmlRequest request = GetOuterHtmlRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).build();
        return ((StringValue)this.rpc.invoke(this.rpc.stub()::getOuterHtml, request)).getValue();
    }

    @Override
    public final boolean outerHtml(String html) {
        Preconditions.checkNotNull(html);
        this.checkNotClosed();
        SetOuterHtmlRequest request = SetOuterHtmlRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).setOuterHtml(html).build();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::setOuterHtml, request)).getValue();
    }

    @Override
    public final String innerText() {
        this.checkNotClosed();
        GetInnerTextRequest request = GetInnerTextRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).build();
        return ((StringValue)this.rpc.invoke(this.rpc.stub()::getInnerText, request)).getValue();
    }

    @Override
    public final boolean innerText(String innerText) {
        Preconditions.checkNotNull(innerText);
        this.checkNotClosed();
        SetInnerTextRequest request = SetInnerTextRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).setInnerText(innerText).build();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::setInnerText, request)).getValue();
    }

    @Override
    public final Rect boundingClientRect() {
        this.checkNotClosed();
        GetBoundingClientRectRequest request = GetBoundingClientRectRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).build();
        return (Rect)this.rpc.invoke(this.rpc.stub()::getBoundingClientRect, request);
    }

    @Override
    public Rect boundingClientRectInViewport() {
        Rect rectInFrame = this.boundingClientRect();
        Point pointInViewport = this.domContext().frame().frameToViewport(rectInFrame.origin());
        return Rect.of(pointInViewport, rectInFrame.size());
    }

    @Override
    public final void focus() {
        this.checkNotClosed();
        FocusRequest request = FocusRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).build();
        this.rpc.invoke(this.rpc.stub()::focus, request);
    }

    @Override
    public final void blur() {
        this.checkNotClosed();
        BlurRequest request = BlurRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).build();
        this.rpc.invoke(this.rpc.stub()::blur, request);
    }

    @Override
    public void scrollIntoView(Element.AlignTo alignTo) {
        Preconditions.checkNotNull(alignTo);
        this.checkNotClosed();
        ScrollIntoViewRequest request = ScrollIntoViewRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).setAlignToTop(alignTo.equals((Object)Element.AlignTo.TOP)).build();
        this.rpc.invoke(this.rpc.stub()::scrollIntoView, request);
    }
}

