/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.download.internal;

import com.teamdev.jxbrowser.deps.com.google.protobuf.BoolValue;
import com.teamdev.jxbrowser.deps.com.google.protobuf.Message;
import com.teamdev.jxbrowser.download.Download;
import com.teamdev.jxbrowser.download.DownloadState;
import com.teamdev.jxbrowser.download.DownloadTarget;
import com.teamdev.jxbrowser.download.event.DownloadEvent;
import com.teamdev.jxbrowser.download.internal.rpc.DownloadRequest;
import com.teamdev.jxbrowser.download.internal.rpc.DownloadStateValue;
import com.teamdev.jxbrowser.download.internal.rpc.DownloadsStub;
import com.teamdev.jxbrowser.event.Observer;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.IdMap;
import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.internal.rpc.DownloadId;
import com.teamdev.jxbrowser.internal.rpc.ProfileId;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.internal.rpc.ServiceMethod;
import com.teamdev.jxbrowser.internal.rpc.transport.Connection;
import com.teamdev.jxbrowser.profile.internal.ProfileImpl;
import java.util.Optional;

public final class DownloadImpl
extends CloseableImpl
implements Download {
    private static final IdMap<DownloadId, DownloadImpl> downloads = new IdMap();
    private final DownloadId id;
    private final DownloadTarget target;
    private final ProfileId profileId;
    private final ServiceConnectionImpl<DownloadsStub> rpc;

    public static Optional<DownloadImpl> findImpl(DownloadId id) {
        Preconditions.checkNotNull(id);
        return downloads.find(id);
    }

    public static Optional<Download> find(DownloadId id) {
        Preconditions.checkNotNull(id);
        return DownloadImpl.findImpl(id).map(d -> d);
    }

    public static Download of(DownloadId id) {
        Preconditions.checkNotNull(id);
        return DownloadImpl.findImpl(id).orElseThrow(IllegalStateException::new);
    }

    DownloadImpl(ProfileImpl profile, Connection connection, DownloadId id, DownloadTarget target) {
        this.id = id;
        this.target = target;
        this.profileId = profile.id();
        this.rpc = new ServiceConnectionImpl<DownloadsStub>(id, connection, DownloadsStub::new);
        downloads.put(id, this);
    }

    @Override
    public void close() {
        downloads.remove(this.id);
        this.rpc.close();
        super.close();
    }

    @Override
    public DownloadTarget target() {
        return this.target;
    }

    private DownloadsStub stub() {
        return this.rpc.stub();
    }

    private <ResponseT extends Message> ResponseT sync(ServiceMethod<DownloadRequest, ResponseT> method) {
        return this.rpc.invoke(method, this.downloadRequest());
    }

    private <ResponseT extends Message> void async(ServiceMethod<DownloadRequest, ResponseT> method) {
        this.rpc.invokeAsync(method, this.downloadRequest());
    }

    private DownloadRequest downloadRequest() {
        return DownloadRequest.newBuilder().setDownloadId(this.id).setProfileId(this.profileId).build();
    }

    @Override
    public DownloadState state() {
        this.checkNotClosed();
        return ((DownloadStateValue)this.sync(this.stub()::getState)).getValue().toPublic();
    }

    @Override
    public boolean isPaused() {
        this.checkNotClosed();
        return ((BoolValue)this.sync(this.stub()::isPaused)).getValue();
    }

    @Override
    public void pause() {
        this.checkNotClosed();
        this.async(this.stub()::pause);
    }

    @Override
    public void resume() {
        this.checkNotClosed();
        this.async(this.stub()::resume);
    }

    @Override
    public void cancel() {
        this.checkNotClosed();
        this.async(this.stub()::cancel);
    }

    @Override
    public <E extends DownloadEvent> Subscription on(Class<E> eventClass, Observer<E> observer) {
        return this.rpc.on(eventClass, observer);
    }
}

