/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.extensions.internal;

import com.teamdev.jxbrowser.browser.Browser;
import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.deps.com.google.protobuf.BoolValue;
import com.teamdev.jxbrowser.deps.com.google.protobuf.StringValue;
import com.teamdev.jxbrowser.engine.RenderingMode;
import com.teamdev.jxbrowser.extensions.Extension;
import com.teamdev.jxbrowser.extensions.ExtensionAction;
import com.teamdev.jxbrowser.extensions.callback.ExtensionCallback;
import com.teamdev.jxbrowser.extensions.internal.ExtensionsImpl;
import com.teamdev.jxbrowser.extensions.internal.rpc.ExtensionStub;
import com.teamdev.jxbrowser.extensions.internal.rpc.OpenExtensionPopup;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.internal.rpc.ExtensionId;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnection;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.internal.rpc.stream.Interceptor;
import com.teamdev.jxbrowser.profile.internal.ProfileImpl;
import java.util.Optional;

class ExtensionImpl
extends CloseableImpl
implements Extension {
    private final ExtensionId extensionId;
    private final ExtensionsImpl extensions;
    private final ServiceConnection<ExtensionStub> rpc;

    ExtensionImpl(String id, ExtensionsImpl extensions) {
        this.extensions = extensions;
        ProfileImpl profile = extensions.profile();
        this.extensionId = ExtensionId.newBuilder().setValue(id).setProfileId(profile.id()).build();
        this.rpc = new ServiceConnectionImpl<ExtensionStub>(this.extensionId, profile.engine().connection(), ExtensionStub::new);
        this.rpc.setCallbackInterceptor(OpenExtensionPopup.Request.class, message -> {
            new BrowserImpl(profile.engine().connection(), profile, message.getPopupBrowserId(), RenderingMode.HARDWARE_ACCELERATED);
            return Interceptor.Action.PROCEED;
        });
    }

    @Override
    public ExtensionsImpl extensions() {
        return this.extensions;
    }

    @Override
    public String id() {
        return this.extensionId.getValue();
    }

    @Override
    public String name() {
        return ((StringValue)this.rpc.invoke(this.rpc.stub()::getName, this.extensionId)).getValue();
    }

    @Override
    public String version() {
        return ((StringValue)this.rpc.invoke(this.rpc.stub()::getVersion, this.extensionId)).getValue();
    }

    @Override
    public Optional<ExtensionAction> action(Browser browser) {
        this.checkNotClosed();
        Preconditions.checkNotNull(browser);
        if (((BoolValue)this.rpc.invoke(this.rpc.stub()::hasAction, this.extensionId)).getValue()) {
            return Optional.of(((BrowserImpl)browser).extensionAction(this));
        }
        return Optional.empty();
    }

    @Override
    public <C extends ExtensionCallback> C set(Class<C> callbackClass, C callback) {
        return (C)((ExtensionCallback)this.rpc.set(callbackClass, callback));
    }

    @Override
    public <C extends ExtensionCallback> Optional<C> get(Class<C> callbackClass) {
        return this.rpc.get(callbackClass);
    }

    @Override
    public <C extends ExtensionCallback> C remove(Class<C> callbackClass) {
        return (C)((ExtensionCallback)this.rpc.remove(callbackClass));
    }

    @Override
    public void close() {
        if (this.isClosed()) {
            return;
        }
        this.rpc.close();
        super.close();
    }
}

