/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.extensions.internal;

import com.teamdev.jxbrowser.annotation.Immutable;
import com.teamdev.jxbrowser.event.Observer;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.extensions.Extension;
import com.teamdev.jxbrowser.extensions.ExtensionInstallationException;
import com.teamdev.jxbrowser.extensions.ExtensionUninstallationException;
import com.teamdev.jxbrowser.extensions.Extensions;
import com.teamdev.jxbrowser.extensions.callback.ExtensionsCallback;
import com.teamdev.jxbrowser.extensions.event.ExtensionsEvent;
import com.teamdev.jxbrowser.extensions.internal.ExtensionImpl;
import com.teamdev.jxbrowser.extensions.internal.rpc.ExtensionInstalled;
import com.teamdev.jxbrowser.extensions.internal.rpc.ExtensionList;
import com.teamdev.jxbrowser.extensions.internal.rpc.ExtensionUninstalled;
import com.teamdev.jxbrowser.extensions.internal.rpc.ExtensionsStub;
import com.teamdev.jxbrowser.extensions.internal.rpc.InstallExtensionRequest;
import com.teamdev.jxbrowser.extensions.internal.rpc.InstallExtensionResponse;
import com.teamdev.jxbrowser.extensions.internal.rpc.UninstallExtensionResponse;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.IdMap;
import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.internal.rpc.ExtensionId;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnection;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.internal.rpc.stream.Interceptor;
import com.teamdev.jxbrowser.profile.internal.ProfileImpl;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Optional;

public class ExtensionsImpl
extends CloseableImpl
implements Extensions {
    private final ProfileImpl profile;
    private final ServiceConnection<ExtensionsStub> rpc;
    private final IdMap<String, ExtensionImpl> extensions;

    public ExtensionsImpl(ProfileImpl profile) {
        Preconditions.checkNotNull(profile);
        this.profile = profile;
        this.extensions = new IdMap();
        this.rpc = new ServiceConnectionImpl<ExtensionsStub>(profile.id(), profile.engine().connection(), ExtensionsStub::new);
        ((ExtensionList)this.rpc.invoke(this.rpc.stub()::getExtensions, profile.id())).getExtensionList().stream().map(extensionId -> new ExtensionImpl(extensionId.getValue(), this)).forEach(extension -> this.extensions.put(extension.id(), (ExtensionImpl)extension));
        this.rpc.setEventInterceptor(ExtensionUninstalled.class, event -> {
            this.extensions.find(event.getExtensionId().getValue()).ifPresent(extension -> {
                extension.close();
                this.extensions.remove(extension.id());
            });
            return Interceptor.Action.PROCEED;
        });
        this.rpc.setEventInterceptor(ExtensionInstalled.class, event -> {
            this.getOrCreateExtension(event.getExtensionId());
            return Interceptor.Action.PROCEED;
        });
    }

    @Override
    public void close() {
        this.extensions.values().forEach(ExtensionImpl::close);
        super.close();
    }

    public Extension findExtension(String extensionId) {
        return this.extensions.find(extensionId).orElseThrow(IllegalStateException::new);
    }

    @Override
    @Immutable
    public List<Extension> list() {
        this.checkNotClosed();
        return List.copyOf(this.extensions.values());
    }

    @Override
    public Extension install(Path path) {
        Preconditions.checkNotNull(path);
        File file = path.toFile();
        Preconditions.checkArgument(file.exists(), "The file does not exist.", new Object[0]);
        Preconditions.checkArgument(file.isFile(), "The path does not lead to a file.", new Object[0]);
        Preconditions.checkArgument(file.getName().toLowerCase(Locale.ROOT).endsWith(".crx"), "The file must have the CRX extension.", new Object[0]);
        this.checkNotClosed();
        InstallExtensionResponse result = (InstallExtensionResponse)this.rpc.invoke(this.rpc.stub()::install, InstallExtensionRequest.newBuilder().setProfileId(this.profile.id()).setFile(path.toAbsolutePath().toString()).build());
        return this.processExtensionInstallation(result);
    }

    @Override
    public void uninstall(Extension extension) {
        this.checkNotClosed();
        String extensionId = extension.id();
        if (!this.extensions.containsKey(extensionId)) {
            throw new IllegalArgumentException("The extension is not installed in this profile.");
        }
        UninstallExtensionResponse response = (UninstallExtensionResponse)this.rpc.invoke(this.rpc.stub()::uninstall, this.getExtensionId(extension));
        if (response.hasError()) {
            throw new ExtensionUninstallationException(response.getError());
        }
        ((ExtensionImpl)extension).close();
        this.extensions.remove(extensionId);
    }

    @Override
    public ProfileImpl profile() {
        return this.profile;
    }

    @Override
    public <E extends ExtensionsEvent> Subscription on(Class<E> eventClass, Observer<E> observer) {
        return this.rpc.on(eventClass, observer);
    }

    private Extension processExtensionInstallation(InstallExtensionResponse result) {
        if (result.hasError()) {
            throw new ExtensionInstallationException(result.getError());
        }
        return this.getOrCreateExtension(result.getExtensionId());
    }

    private synchronized ExtensionImpl getOrCreateExtension(ExtensionId id) {
        String extensionId = id.getValue();
        return this.extensions.find(extensionId).orElseGet(() -> {
            ExtensionImpl extension = new ExtensionImpl(extensionId, this);
            this.extensions.put(extension.id(), extension);
            return extension;
        });
    }

    private ExtensionId getExtensionId(Extension extension) {
        return ExtensionId.newBuilder().setProfileId(this.profile.id()).setValue(extension.id()).build();
    }

    @Override
    public <C extends ExtensionsCallback> C set(Class<C> callbackClass, C callback) {
        return (C)((ExtensionsCallback)this.rpc.set(callbackClass, callback));
    }

    @Override
    public <C extends ExtensionsCallback> Optional<C> get(Class<C> callbackClass) {
        return this.rpc.get(callbackClass);
    }

    @Override
    public <C extends ExtensionsCallback> C remove(Class<C> callbackClass) {
        return (C)((ExtensionsCallback)this.rpc.remove(callbackClass));
    }
}

