/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.frame.internal;

import com.teamdev.jxbrowser.dom.Element;
import com.teamdev.jxbrowser.dom.Node;
import com.teamdev.jxbrowser.dom.internal.AttributeImpl;
import com.teamdev.jxbrowser.dom.internal.DocumentImpl;
import com.teamdev.jxbrowser.dom.internal.ElementImpl;
import com.teamdev.jxbrowser.dom.internal.FormElementImpl;
import com.teamdev.jxbrowser.dom.internal.FrameElementImpl;
import com.teamdev.jxbrowser.dom.internal.ImageElementImpl;
import com.teamdev.jxbrowser.dom.internal.InputElementImpl;
import com.teamdev.jxbrowser.dom.internal.NodeImpl;
import com.teamdev.jxbrowser.dom.internal.OptionElementImpl;
import com.teamdev.jxbrowser.dom.internal.SelectElementImpl;
import com.teamdev.jxbrowser.dom.internal.TextAreaElementImpl;
import com.teamdev.jxbrowser.dom.internal.rpc.NodeInfo;
import com.teamdev.jxbrowser.dom.internal.rpc.NodeType;
import com.teamdev.jxbrowser.frame.internal.FrameImpl;
import com.teamdev.jxbrowser.frame.internal.PageContext;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.internal.ProtobufMessages;
import com.teamdev.jxbrowser.internal.Wrappers;
import com.teamdev.jxbrowser.internal.rpc.NodeId;
import com.teamdev.jxbrowser.internal.rpc.transport.Connection;
import com.teamdev.jxbrowser.js.internal.JsContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;

public final class DomContext
extends CloseableImpl {
    private final FrameImpl frame;
    private final PageContext pageContext;
    private final Map<NodeId, NodeImpl> nodes;

    private DomContext(FrameImpl frame, PageContext pageContext) {
        this.frame = frame;
        this.pageContext = pageContext;
        this.nodes = new ConcurrentHashMap<NodeId, NodeImpl>();
    }

    static DomContext newInstance(FrameImpl frame, PageContext pageContext) {
        Preconditions.checkNotNull(frame);
        Preconditions.checkNotNull(pageContext);
        return new DomContext(frame, pageContext);
    }

    public JsContext jsContext() {
        return this.pageContext.jsContext();
    }

    public FrameImpl frame() {
        return this.frame;
    }

    @Override
    public void close() {
        this.nodes.forEach((nodeId, node) -> node.makeClosed());
        super.close();
    }

    public void onNodeClosed(NodeId id) {
        this.nodes.remove(id);
    }

    public Node toNode(NodeInfo nodeInfo) {
        Preconditions.checkNotNull(nodeInfo);
        Preconditions.checkArgument(!ProtobufMessages.isDefault(nodeInfo), "Can't create an object from the empty NodeInfo", new Object[0]);
        return this.existingNode(nodeInfo).orElseGet(() -> this.createNode(nodeInfo));
    }

    public <T> T toNode(NodeInfo nodeInfo, Class<T> nodeClass) {
        Preconditions.checkNotNull(nodeClass);
        Node node = this.toNode(nodeInfo);
        try {
            return Wrappers.unwrap(node, nodeClass);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("The NodeInfo doesn't match the expected type", e);
        }
    }

    public Optional<Node> toOptionalNode(NodeInfo nodeInfo) {
        Preconditions.checkNotNull(nodeInfo);
        if (ProtobufMessages.isDefault(nodeInfo)) {
            return Optional.empty();
        }
        return Optional.of(this.toNode(nodeInfo));
    }

    public <T> Optional<T> toOptionalNode(NodeInfo nodeInfo, Class<T> nodeClass) {
        Preconditions.checkNotNull(nodeInfo);
        if (ProtobufMessages.isDefault(nodeInfo)) {
            return Optional.empty();
        }
        return Optional.of(this.toNode(nodeInfo, nodeClass));
    }

    public List<Node> toNodes(Iterable<NodeInfo> nodeInfos) {
        Preconditions.checkNotNull(nodeInfos);
        ArrayList<Node> result = new ArrayList<Node>();
        nodeInfos.spliterator().forEachRemaining(nodeInfo -> result.add(this.toNode((NodeInfo)nodeInfo)));
        return result;
    }

    public <T> List<T> toNodes(Iterable<NodeInfo> nodeInfos, Class<T> nodeClass) {
        Preconditions.checkNotNull(nodeInfos);
        ArrayList result = new ArrayList();
        nodeInfos.spliterator().forEachRemaining(nodeInfo -> result.add(this.toNode((NodeInfo)nodeInfo, nodeClass)));
        return result;
    }

    private Node createNode(NodeInfo nodeInfo) {
        Connection connection = this.connection();
        Node result = DomContext.isDocument(nodeInfo) ? DocumentImpl.newInstance(connection, this, nodeInfo) : (DomContext.isElement(nodeInfo) ? this.createElement(nodeInfo) : (DomContext.isAttribute(nodeInfo) ? AttributeImpl.newInstance(connection, this, nodeInfo) : NodeImpl.newInstance(connection, this, nodeInfo)));
        this.registerNode((NodeImpl)result);
        return result;
    }

    private void registerNode(NodeImpl node) {
        NodeId nodeId = node.nodeInfo().getNodeId();
        this.nodes.put(nodeId, node);
        this.jsContext().registerJsObject(node);
    }

    private Element createElement(NodeInfo nodeInfo) {
        ElementTag element = ElementTag.from(nodeInfo.getTagName());
        Connection connection = this.connection();
        ElementImpl result = switch (element.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> FormElementImpl.newInstance(connection, this, nodeInfo);
            case 1 -> SelectElementImpl.newInstance(connection, this, nodeInfo);
            case 2 -> OptionElementImpl.newInstance(connection, this, nodeInfo);
            case 3 -> InputElementImpl.newInstance(connection, this, nodeInfo);
            case 4 -> TextAreaElementImpl.newInstance(connection, this, nodeInfo);
            case 7 -> ImageElementImpl.newInstance(connection, this, nodeInfo);
            case 5, 6 -> FrameElementImpl.newInstance(connection, this, nodeInfo);
            case 8 -> ElementImpl.newInstance(connection, this, nodeInfo);
        };
        return result;
    }

    private Optional<Node> existingNode(NodeInfo nodeInfo) {
        NodeId nodeId = nodeInfo.getNodeId();
        return Optional.ofNullable((Node)this.nodes.get(nodeId));
    }

    private Connection connection() {
        return this.frame.renderProcess().connection();
    }

    private static boolean isElement(NodeInfo nodeInfo) {
        return nodeInfo.getNodeType() == NodeType.ELEMENT_NODE;
    }

    private static boolean isDocument(NodeInfo nodeInfo) {
        return nodeInfo.getNodeType() == NodeType.DOCUMENT_NODE;
    }

    private static boolean isAttribute(NodeInfo nodeInfo) {
        return nodeInfo.getNodeType() == NodeType.ATTRIBUTE_NODE;
    }

    private static enum ElementTag {
        FORM("form"),
        SELECT("select"),
        OPTION("option"),
        INPUT("input"),
        TEXT_AREA("textarea"),
        FRAME("frame"),
        IFRAME("iframe"),
        IMAGE("img"),
        OTHER_ELEMENT("");

        private final String tagName;

        private ElementTag(String tagName) {
            this.tagName = tagName;
        }

        private String tagName() {
            return this.tagName;
        }

        private static ElementTag from(String tagName) {
            return Stream.of(ElementTag.values()).filter(value -> value.tagName().equalsIgnoreCase(tagName)).findFirst().orElse(OTHER_ELEMENT);
        }
    }
}

