/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.frame.internal;

import com.teamdev.jxbrowser.browser.Browser;
import com.teamdev.jxbrowser.browser.callback.InjectCssCallback;
import com.teamdev.jxbrowser.browser.callback.InjectJsCallback;
import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.browser.internal.RenderProcess;
import com.teamdev.jxbrowser.browser.internal.rpc.BrowserStub;
import com.teamdev.jxbrowser.browser.internal.rpc.TargetFrame;
import com.teamdev.jxbrowser.deps.com.google.protobuf.BoolValue;
import com.teamdev.jxbrowser.deps.com.google.protobuf.StringValue;
import com.teamdev.jxbrowser.dom.Document;
import com.teamdev.jxbrowser.dom.PointInspection;
import com.teamdev.jxbrowser.dom.internal.rpc.NodeInfo;
import com.teamdev.jxbrowser.dom.internal.rpc.StorageType;
import com.teamdev.jxbrowser.frame.EditorCommand;
import com.teamdev.jxbrowser.frame.Frame;
import com.teamdev.jxbrowser.frame.WebStorage;
import com.teamdev.jxbrowser.frame.internal.DomContext;
import com.teamdev.jxbrowser.frame.internal.PageContext;
import com.teamdev.jxbrowser.frame.internal.WebStorageImpl;
import com.teamdev.jxbrowser.frame.internal.callback.CanAccessMemberCallback;
import com.teamdev.jxbrowser.frame.internal.callback.GetObjectTypeCallback;
import com.teamdev.jxbrowser.frame.internal.callback.InjectCssCallback;
import com.teamdev.jxbrowser.frame.internal.callback.InjectJsCallback;
import com.teamdev.jxbrowser.frame.internal.callback.InvokeMethodCallback;
import com.teamdev.jxbrowser.frame.internal.callback.ReadFieldCallback;
import com.teamdev.jxbrowser.frame.internal.callback.SwitchPageContextsCallback;
import com.teamdev.jxbrowser.frame.internal.callback.UpdateFieldCallback;
import com.teamdev.jxbrowser.frame.internal.convert.JavaValue;
import com.teamdev.jxbrowser.frame.internal.rpc.CanAccessMember;
import com.teamdev.jxbrowser.frame.internal.rpc.CreateJsProxyObjectRequest;
import com.teamdev.jxbrowser.frame.internal.rpc.EditorCommandName;
import com.teamdev.jxbrowser.frame.internal.rpc.ExecuteJavaScriptRequest;
import com.teamdev.jxbrowser.frame.internal.rpc.FinishFrameLoad;
import com.teamdev.jxbrowser.frame.internal.rpc.FrameCreated;
import com.teamdev.jxbrowser.frame.internal.rpc.FrameStub;
import com.teamdev.jxbrowser.frame.internal.rpc.GetObjectType;
import com.teamdev.jxbrowser.frame.internal.rpc.InvokeMethod;
import com.teamdev.jxbrowser.frame.internal.rpc.LoadUrlRequest;
import com.teamdev.jxbrowser.frame.internal.rpc.Location;
import com.teamdev.jxbrowser.frame.internal.rpc.MemberAccessError;
import com.teamdev.jxbrowser.frame.internal.rpc.PointInFrame;
import com.teamdev.jxbrowser.frame.internal.rpc.ReadField;
import com.teamdev.jxbrowser.frame.internal.rpc.SpellCheckCompleted;
import com.teamdev.jxbrowser.frame.internal.rpc.SwitchPageContexts;
import com.teamdev.jxbrowser.frame.internal.rpc.UpdateField;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.IdMap;
import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.internal.ProtobufMessages;
import com.teamdev.jxbrowser.internal.Wrappers;
import com.teamdev.jxbrowser.internal.rpc.FrameId;
import com.teamdev.jxbrowser.internal.rpc.FrameIdList;
import com.teamdev.jxbrowser.internal.rpc.JsObjectProxyId;
import com.teamdev.jxbrowser.internal.rpc.PageContextId;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.internal.rpc.stream.Interceptor;
import com.teamdev.jxbrowser.internal.rpc.transport.Connection;
import com.teamdev.jxbrowser.internal.rpc.transport.RpcCallback;
import com.teamdev.jxbrowser.internal.string.StringPreconditions;
import com.teamdev.jxbrowser.js.Json;
import com.teamdev.jxbrowser.js.internal.JsAccessibleObject;
import com.teamdev.jxbrowser.js.internal.JsCallbackResponses;
import com.teamdev.jxbrowser.js.internal.JsContext;
import com.teamdev.jxbrowser.js.internal.JsonImpl;
import com.teamdev.jxbrowser.js.internal.rpc.JsValue;
import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.ui.Point;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

public final class FrameImpl
extends CloseableImpl
implements Frame {
    private static final IdMap<FrameId, FrameImpl> frames = new IdMap();
    private final RenderProcess renderProcess;
    private final AtomicReference<PageContext> pageContext;
    private final FrameId id;
    private final boolean isMain;
    private final JsonImpl json;
    private final BrowserImpl browser;
    private final WebStorageImpl localStorage;
    private final WebStorageImpl sessionStorage;
    private final ServiceConnectionImpl<FrameStub> rpc;
    private final ServiceConnectionImpl<BrowserStub> browserRpc;

    public static Optional<FrameImpl> findImpl(FrameId frame) {
        Preconditions.checkNotNull(frame);
        Logger.debug(() -> "Finding frame with id: " + String.valueOf(frame));
        return frames.find(frame);
    }

    public static Optional<Frame> find(FrameId frame) {
        Preconditions.checkNotNull(frame);
        return FrameImpl.findImpl(frame).map(fr -> fr);
    }

    public static FrameImpl of(FrameId id) {
        Preconditions.checkNotNull(id);
        return FrameImpl.findImpl(id).orElseThrow(IllegalStateException::new);
    }

    private FrameImpl(BrowserImpl browser, RenderProcess renderProcess, FrameId frameId, PageContextId pageContextId, boolean isMain) {
        this.id = Preconditions.checkNotNull(frameId);
        this.browser = Preconditions.checkNotNull(browser);
        this.renderProcess = Preconditions.checkNotNull(renderProcess);
        this.isMain = isMain;
        Connection connection = renderProcess.connection();
        this.localStorage = new WebStorageImpl(connection, StorageType.LOCAL, frameId);
        this.sessionStorage = new WebStorageImpl(connection, StorageType.SESSION, frameId);
        this.json = new JsonImpl(this);
        this.pageContext = new AtomicReference<PageContext>(PageContext.newInstance(this, pageContextId));
        this.browserRpc = new ServiceConnectionImpl<BrowserStub>(browser.id(), browser.connection(), BrowserStub::new);
        this.rpc = new ServiceConnectionImpl<FrameStub>(frameId, connection, FrameStub::new);
        this.rpc.set(CanAccessMemberCallback.class, this::processCallback);
        this.rpc.set(UpdateFieldCallback.class, this::processCallback);
        this.rpc.set(ReadFieldCallback.class, this::processCallback);
        this.rpc.set(GetObjectTypeCallback.class, this::processCallback);
        this.rpc.set(InvokeMethodCallback.class, this::processCallback);
        this.rpc.set(InjectCssCallback.class, this::processCallback);
        this.rpc.set(InjectJsCallback.class, this::processCallback);
        this.rpc.setCallbackInterceptor(FinishFrameLoad.Request.class, request -> {
            browser.notifyNavigationObservers(request.getEvent());
            return Interceptor.Action.PROCEED;
        });
        this.rpc.set(SwitchPageContextsCallback.class, this::switchPageContexts);
        this.rpc.on(SpellCheckCompleted.class, browser::notifyObservers);
        renderProcess.addFrame(this);
    }

    static FrameImpl onEvent(BrowserImpl browser, RenderProcess process, FrameCreated event) {
        return new FrameImpl(browser, process, event.getFrameId(), event.getPageContextId(), event.getIsMainFrame());
    }

    private SwitchPageContexts.Response switchPageContexts(SwitchPageContexts.Request params) {
        PageContext oldContext = this.pageContext.getAndSet(PageContext.newInstance(this, params.getNewContextId()));
        oldContext.close();
        return SwitchPageContextsCallback.proceed();
    }

    private InjectJsCallback.Response processCallback(InjectJsCallback.Params params) {
        return this.browser.get(com.teamdev.jxbrowser.browser.callback.InjectJsCallback.class).map(callback -> (InjectJsCallback.Response)callback.on(params)).orElse(InjectJsCallback.Response.proceed());
    }

    private InjectCssCallback.Response processCallback(InjectCssCallback.Params params) {
        return this.browser.get(com.teamdev.jxbrowser.browser.callback.InjectCssCallback.class).map(callback -> (InjectCssCallback.Response)callback.on(params)).orElse(InjectCssCallback.Response.proceed());
    }

    private InvokeMethod.Response processCallback(InvokeMethod.Request params) {
        JsObjectProxyId objectProxyId = params.getObjectProxyId();
        JsContext jsContext = JsContext.of(objectProxyId.getPageContextId());
        return jsContext.jsAccessibleObject(objectProxyId).map(object -> object.invokeMethod(jsContext, params)).orElse(JsCallbackResponses.invokeMethodResponse("No such java object"));
    }

    private CanAccessMember.Response processCallback(CanAccessMember.Request params) {
        JsObjectProxyId objectProxyId = params.getObjectProxyId();
        JsContext jsContext = JsContext.of(objectProxyId.getPageContextId());
        return jsContext.jsAccessibleObject(objectProxyId).map(object -> object.canAccessMember(params)).orElse(JsCallbackResponses.canAccessMemberResponse(MemberAccessError.OBJECT_NOT_FOUND));
    }

    private UpdateField.Response processCallback(UpdateField.Request params) {
        JsObjectProxyId objectProxyId = params.getObjectProxyId();
        JsContext jsContext = JsContext.of(objectProxyId.getPageContextId());
        return jsContext.jsAccessibleObject(objectProxyId).map(object -> object.updateField(params)).orElse(JsCallbackResponses.updateFieldResponse(MemberAccessError.OBJECT_NOT_FOUND));
    }

    private ReadField.Response processCallback(ReadField.Request params) {
        JsObjectProxyId objectProxyId = params.getObjectProxyId();
        JsContext jsContext = JsContext.of(objectProxyId.getPageContextId());
        return jsContext.jsAccessibleObject(objectProxyId).map(object -> object.readField(jsContext, params)).orElse(JsCallbackResponses.readFieldResponse(MemberAccessError.OBJECT_NOT_FOUND));
    }

    private GetObjectType.Response processCallback(GetObjectType.Request params) {
        JsObjectProxyId objectProxyId = params.getObjectProxyId();
        JsContext jsContext = JsContext.of(objectProxyId.getPageContextId());
        return jsContext.jsAccessibleObject(objectProxyId).map(JsAccessibleObject::objectType).orElse(JsCallbackResponses.getObjectTypeResponse("No such java object"));
    }

    public DomContext domContext(NodeInfo nodeInfo) {
        Preconditions.checkArgument(!ProtobufMessages.isDefault(nodeInfo));
        PageContextId contextId = nodeInfo.getJsObjectId().getPageContextId();
        return PageContext.of(contextId).domContext();
    }

    @Override
    public RenderProcess renderProcess() {
        return this.renderProcess;
    }

    @Override
    public void close() {
        if (this.isClosed()) {
            return;
        }
        this.rpc.close();
        this.localStorage.close();
        this.sessionStorage.close();
        this.renderProcess.removeFrame(this);
        this.pageContext.get().close();
        super.close();
    }

    public FrameId id() {
        return this.id;
    }

    @Override
    public Browser browser() {
        return this.browser;
    }

    @Override
    public boolean isMain() {
        return this.isMain;
    }

    @Override
    public String name() {
        this.checkNotClosed();
        return ((StringValue)this.rpc.invoke(this.stub()::getName, this.id)).getValue();
    }

    @Override
    public String html() {
        this.checkNotClosed();
        return ((StringValue)this.rpc.invoke(this.stub()::getHtml, this.id)).getValue();
    }

    @Override
    public String text() {
        this.checkNotClosed();
        return ((StringValue)this.rpc.invoke(this.stub()::getText, this.id)).getValue();
    }

    @Override
    public void viewSource() {
        this.checkNotClosed();
        this.browser.viewSource(this.id);
    }

    @Override
    public void loadUrl(String url) {
        StringPreconditions.checkNotNullEmptyOrBlank(url);
        this.checkNotClosed();
        LoadUrlRequest request = LoadUrlRequest.newBuilder().setFrameId(this.id).setUrl(url).build();
        this.rpc.invokeAsync(this.stub()::loadUrl, request);
    }

    @Override
    public <T> T executeJavaScript(String javaScript) {
        Preconditions.checkNotNull(javaScript);
        Preconditions.checkArgument(!javaScript.trim().isEmpty());
        return this.executeJavaScript(javaScript, false).toReturnValue();
    }

    @Override
    public void executeJavaScript(String javaScript, final Consumer<?> callback) {
        Preconditions.checkNotNull(javaScript);
        Preconditions.checkArgument(!javaScript.trim().isEmpty());
        Preconditions.checkNotNull(callback);
        this.checkNotClosed();
        ExecuteJavaScriptRequest request = ExecuteJavaScriptRequest.newBuilder().setFrameId(this.id).setJavaScript(javaScript).build();
        this.rpc.invokeAsync(this.stub()::executeJavaScript, request, new RpcCallback<JsValue>(){

            @Override
            public void onNext(JsValue jsValue) {
                JavaValue value = JavaValue.from(jsValue);
                callback.accept(value.toReturnValue());
            }

            @Override
            public void onError(Throwable t) {
                Logger.warn("Failed to execute JavaScript.", t);
            }
        });
    }

    public JavaValue executeJavaScript(String javaScript, boolean userGesture) {
        Preconditions.checkNotNull(javaScript);
        this.checkNotClosed();
        ExecuteJavaScriptRequest request = ExecuteJavaScriptRequest.newBuilder().setFrameId(this.id).setJavaScript(javaScript).setUserGesture(userGesture).build();
        com.teamdev.jxbrowser.js.internal.JsValue jsValue = (com.teamdev.jxbrowser.js.internal.JsValue)this.rpc.invoke(this.stub()::executeJavaScript, request);
        return JavaValue.from(jsValue);
    }

    @Override
    public boolean execute(EditorCommand command) {
        Preconditions.checkNotNull(command);
        this.checkNotClosed();
        EditorCommandName editorCommandName = EditorCommandName.newBuilder().setFrameId(this.id).setCommandName(command.name().value()).build();
        return ((BoolValue)this.rpc.invoke(this.stub()::executeEditorCommand, com.teamdev.jxbrowser.frame.internal.rpc.EditorCommand.newBuilder().setCommandName(editorCommandName).setCommandValue(command.value()).build())).getValue();
    }

    @Override
    public boolean isCommandEnabled(EditorCommand.Name commandName) {
        this.checkNotClosed();
        EditorCommandName request = EditorCommandName.newBuilder().setFrameId(this.id).setCommandName(commandName.value()).build();
        return ((BoolValue)this.rpc.invoke(this.stub()::isEditorCommandEnabled, request)).getValue();
    }

    @Override
    public void print() {
        this.checkNotClosed();
        this.browser.print(this.id);
    }

    @Override
    public Json json() {
        this.checkNotClosed();
        return this.json;
    }

    @Override
    public WebStorage localStorage() {
        this.checkNotClosed();
        return this.localStorage;
    }

    @Override
    public WebStorage sessionStorage() {
        this.checkNotClosed();
        return this.sessionStorage;
    }

    @Override
    public boolean hasSelection() {
        this.checkNotClosed();
        return ((BoolValue)this.rpc.invoke(this.stub()::hasSelection, this.id)).getValue();
    }

    @Override
    public String selectionAsText() {
        this.checkNotClosed();
        return ((StringValue)this.rpc.invoke(this.stub()::getSelectionAsText, this.id)).getValue();
    }

    @Override
    public String selectionAsHtml() {
        this.checkNotClosed();
        return ((StringValue)this.rpc.invoke(this.stub()::getSelectionAsMarkup, this.id)).getValue();
    }

    @Override
    public Optional<Document> document() {
        this.checkNotClosed();
        NodeInfo response = (NodeInfo)this.rpc.invoke(this.stub()::getDocument, this.id);
        Document document = !ProtobufMessages.isDefault(response) ? this.domContext(response).toNode(response, Document.class) : null;
        return Optional.ofNullable(document);
    }

    @Override
    public PointInspection inspect(Point location) {
        Preconditions.checkNotNull(location);
        this.checkNotClosed();
        com.teamdev.jxbrowser.ui.internal.rpc.Point point = Wrappers.unwrap(location, com.teamdev.jxbrowser.ui.internal.rpc.Point.class);
        Location request = Location.newBuilder().setFrameId(this.id).setPoint(point).build();
        return (PointInspection)this.rpc.invoke(this.stub()::inspect, request);
    }

    @Override
    public PointInspection inspect(int x, int y) {
        return this.inspect(Point.of(x, y));
    }

    @Override
    public Optional<Frame> parent() {
        this.checkNotClosed();
        TargetFrame request = TargetFrame.newBuilder().setBrowserId(this.browser.id()).setTargetFrameId(this.id).build();
        FrameId frameId = (FrameId)this.browserRpc.invoke(this.browser.browserStub()::getParentFrame, request);
        return FrameImpl.findImpl(frameId).map(frame -> frame);
    }

    private FrameStub stub() {
        return this.rpc.stub();
    }

    @Override
    public List<Frame> children() {
        this.checkNotClosed();
        TargetFrame request = TargetFrame.newBuilder().setBrowserId(this.browser.id()).setTargetFrameId(this.id).build();
        FrameIdList frameList = (FrameIdList)this.browserRpc.invoke(this.browser.browserStub()::getChildFrames, request);
        return frameList.getFrameIdList().stream().map(id -> FrameImpl.of(id)).toList();
    }

    public void unregister() {
        frames.remove(this.id);
    }

    void register() {
        frames.put(this.id, this);
    }

    public JsObjectProxyId createJsProxyObject(Set<String> fields, Set<String> methods) {
        return this.newJsProxyObject(fields, methods);
    }

    public JsObjectProxyId createJsProxyFunction() {
        return this.newJsProxyFunction();
    }

    private JsObjectProxyId newJsProxyObject(Set<String> fieldNames, Set<String> methodNames) {
        CreateJsProxyObjectRequest request = CreateJsProxyObjectRequest.newBuilder().setFrameId(this.id).addAllFields(fieldNames).addAllMethods(methodNames).setIsFunction(false).build();
        return (JsObjectProxyId)this.rpc.invoke(this.rpc.stub()::createJsProxyObject, request);
    }

    private JsObjectProxyId newJsProxyFunction() {
        CreateJsProxyObjectRequest request = CreateJsProxyObjectRequest.newBuilder().setFrameId(this.id).setIsFunction(true).build();
        return (JsObjectProxyId)this.rpc.invoke(this.rpc.stub()::createJsProxyObject, request);
    }

    public Point viewportToFrame(Point pointInViewport) {
        this.checkNotClosed();
        Location request = Location.newBuilder().setFrameId(this.id).setPoint(Wrappers.unwrap(pointInViewport, com.teamdev.jxbrowser.ui.internal.rpc.Point.class)).build();
        return (Point)this.rpc.invoke(this.stub()::transformRootPointToFramePoint, request);
    }

    public Point frameToViewport(Point pointInFrame) {
        PointInFrame request = PointInFrame.newBuilder().setFrameId(this.id).setPoint(Wrappers.unwrap(pointInFrame, com.teamdev.jxbrowser.ui.internal.rpc.Point.class)).build();
        return (Point)this.rpc.invoke(this.rpc.stub()::transformFramePointToRootViewPoint, request);
    }
}

