/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.frame.internal.convert;

import com.teamdev.jxbrowser.frame.internal.convert.CollectionValue;
import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.internal.rpc.JsObjectId;
import com.teamdev.jxbrowser.js.JsArrayBuffer;
import com.teamdev.jxbrowser.js.internal.JsArrayBufferImpl;
import com.teamdev.jxbrowser.js.internal.rpc.JsValue;
import java.util.List;

final class ArrayBufferValue
extends CollectionValue {
    ArrayBufferValue(JsValue jsValue) {
        super(jsValue);
        Preconditions.checkArgument(jsValue.getValueCase() == JsValue.ValueCase.ARRAY_BUFFER);
    }

    @Override
    public List<Class<?>> destinationTypes() {
        return List.of(byte[].class, JsArrayBuffer.class);
    }

    @Override
    public <T> T toObject(Class<?> type) {
        Preconditions.checkNotNull(type);
        Preconditions.checkArgument(this.isConvertibleTo(type), "Cannot convert the value to: %s", type);
        JsObjectId objectId = this.jsValue().getArrayBuffer().getId();
        JsArrayBufferImpl jsArrayBuffer = this.getOrCreateJsObject(objectId, JsArrayBufferImpl.class);
        if (type.equals(byte[].class)) {
            return (T)jsArrayBuffer.bytes();
        }
        return (T)jsArrayBuffer;
    }
}

