/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.frame.internal.convert;

import com.teamdev.jxbrowser.frame.internal.convert.ArrayBufferValue;
import com.teamdev.jxbrowser.frame.internal.convert.ArrayValue;
import com.teamdev.jxbrowser.frame.internal.convert.BooleanValue;
import com.teamdev.jxbrowser.frame.internal.convert.FunctionValue;
import com.teamdev.jxbrowser.frame.internal.convert.JavaValue;
import com.teamdev.jxbrowser.frame.internal.convert.MapValue;
import com.teamdev.jxbrowser.frame.internal.convert.NodeValue;
import com.teamdev.jxbrowser.frame.internal.convert.NullOrUndefinedValue;
import com.teamdev.jxbrowser.frame.internal.convert.NumberValue;
import com.teamdev.jxbrowser.frame.internal.convert.ObjectValue;
import com.teamdev.jxbrowser.frame.internal.convert.PromiseValue;
import com.teamdev.jxbrowser.frame.internal.convert.ProxyObjectValue;
import com.teamdev.jxbrowser.frame.internal.convert.SetValue;
import com.teamdev.jxbrowser.frame.internal.convert.StringValue;
import com.teamdev.jxbrowser.frame.internal.convert.SymbolValue;
import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.js.internal.rpc.JsValue;
import java.util.HashMap;
import java.util.Map;

final class JavaValues {
    private static final Map<JsValue.ValueCase, JavaValueConstructor> constructors;

    static JavaValue create(JsValue jsValue) {
        Preconditions.checkArgument(constructors.containsKey(jsValue.getValueCase()));
        return constructors.get(jsValue.getValueCase()).newInstance(jsValue);
    }

    private JavaValues() {
    }

    static {
        HashMap<JsValue.ValueCase, JavaValueConstructor> map = new HashMap<JsValue.ValueCase, JavaValueConstructor>();
        map.put(JsValue.ValueCase.NUMBER_VALUE, NumberValue::newInstance);
        map.put(JsValue.ValueCase.STRING_VALUE, StringValue::new);
        map.put(JsValue.ValueCase.BOOL_VALUE, BooleanValue::new);
        map.put(JsValue.ValueCase.NODE_INFO, NodeValue::new);
        map.put(JsValue.ValueCase.OBJECT_ID, ObjectValue::new);
        map.put(JsValue.ValueCase.SYMBOL, SymbolValue::new);
        map.put(JsValue.ValueCase.OBJECT_PROXY_ID, ProxyObjectValue::new);
        map.put(JsValue.ValueCase.FUNCTION_ID, FunctionValue::new);
        map.put(JsValue.ValueCase.PROMISE_ID, PromiseValue::new);
        map.put(JsValue.ValueCase.ARRAY, ArrayValue::new);
        map.put(JsValue.ValueCase.SET, SetValue::new);
        map.put(JsValue.ValueCase.MAP, MapValue::new);
        map.put(JsValue.ValueCase.ARRAY_BUFFER, ArrayBufferValue::new);
        map.put(JsValue.ValueCase.NULL_OR_UNDEFINED, NullOrUndefinedValue::new);
        constructors = Map.copyOf(map);
    }

    @FunctionalInterface
    static interface JavaValueConstructor {
        public JavaValue newInstance(JsValue var1);
    }
}

