/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal;

import com.teamdev.jxbrowser.VersionInfo;
import com.teamdev.jxbrowser.engine.EngineOptions;
import com.teamdev.jxbrowser.internal.ChromiumBundleMac;
import com.teamdev.jxbrowser.internal.ChromiumProcess;
import com.teamdev.jxbrowser.internal.ChromiumSwitches;
import com.teamdev.jxbrowser.internal.SystemProperties;
import com.teamdev.jxbrowser.internal.ToolkitLibrary;
import com.teamdev.jxbrowser.os.Environment;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public final class ChromiumProcessMac
extends ChromiumProcess {
    public static final String CF_PROCESS_PATH = "CFProcessPath";
    private static final String MAC_APP_GROUP = "jxbrowser.mas.app.group";

    ChromiumProcessMac(int port, Path chromiumDir) {
        super(port, chromiumDir);
    }

    @Override
    protected void preProcessRun(ProcessBuilder processBuilder, EngineOptions options) throws IOException {
        super.preProcessRun(processBuilder, options);
        if (System.getenv().containsKey(CF_PROCESS_PATH)) {
            processBuilder.environment().remove(CF_PROCESS_PATH);
        }
    }

    @Override
    protected Optional<String> defaultCrashDumpDir() {
        return Optional.of(Environment.userHomeDir().resolve("Library").resolve("Application Support").resolve("JxBrowser").resolve(VersionInfo.version()).resolve("CrashReports").toAbsolutePath().toString());
    }

    public static Optional<String> appGroup() {
        if (!ChromiumProcessMac.isInAppleSandbox()) {
            return Optional.empty();
        }
        String result = ToolkitLibrary.instance().getApplicationGroups();
        List<String> appGroups = Arrays.stream(result.split("\n")).filter(s -> !s.isEmpty()).toList();
        String specifiedAppGroup = SystemProperties.get(MAC_APP_GROUP, "");
        if (!specifiedAppGroup.isEmpty()) {
            if (!appGroups.contains(specifiedAppGroup)) {
                throw ChromiumProcessMac.appGroupNotFoundException(specifiedAppGroup);
            }
            return Optional.of(specifiedAppGroup);
        }
        if (appGroups.size() == 1) {
            return Optional.of(appGroups.get(0));
        }
        if (appGroups.isEmpty()) {
            throw ChromiumProcessMac.noAppGroupsFoundException();
        }
        throw ChromiumProcessMac.ambiguousAppGroupException();
    }

    @Override
    protected Collection<String> platformCommandLineArgs(EngineOptions engineOptions) {
        ChromiumSwitches switches = new ChromiumSwitches();
        switches.add("browser-subprocess-path", ChromiumBundleMac.helperExecutablePath(this.workingDir()).toString());
        switches.add("use-mock-keychain");
        ChromiumProcessMac.appGroup().ifPresent(group -> switches.add("app-group", group));
        return switches.toList();
    }

    private static boolean isInAppleSandbox() {
        return ToolkitLibrary.instance().isInAppleSandbox();
    }

    private static IllegalStateException appGroupNotFoundException(String appGroup) {
        return new IllegalStateException(String.format("The specified app group '%s' is not found in the application entitlements.", appGroup));
    }

    private static IllegalStateException noAppGroupsFoundException() {
        return new IllegalStateException("The application is running in Apple sandbox but no app groups are defined in the application entitlements. Please add an app group to the 'com.apple.security.application-groups' entitlement.");
    }

    private static IllegalStateException ambiguousAppGroupException() {
        return new IllegalStateException(String.format("The entitlements contain multiple app groups. Please specify the required app group using the '%s' system property.", MAC_APP_GROUP));
    }
}

