/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal.rpc;

import com.teamdev.jxbrowser.callback.Callback;
import com.teamdev.jxbrowser.callback.internal.AdvisableHelper;
import com.teamdev.jxbrowser.deps.com.google.protobuf.Descriptors;
import com.teamdev.jxbrowser.deps.com.google.protobuf.Message;
import com.teamdev.jxbrowser.event.Event;
import com.teamdev.jxbrowser.event.Observer;
import com.teamdev.jxbrowser.event.internal.ObservableHelper;
import com.teamdev.jxbrowser.event.internal.SubscriptionImpl;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.rpc.Service;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnection;
import com.teamdev.jxbrowser.internal.rpc.ServiceMethod;
import com.teamdev.jxbrowser.internal.rpc.stream.Interceptor;
import com.teamdev.jxbrowser.internal.rpc.stream.util.CallbackType;
import com.teamdev.jxbrowser.internal.rpc.stream.util.EventType;
import com.teamdev.jxbrowser.internal.rpc.stream.util.ParamsType;
import com.teamdev.jxbrowser.internal.rpc.transport.RpcCallback;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;

public final class LocalServiceConnection
extends CloseableImpl
implements ServiceConnection<FakeService> {
    private final Set<Class<? extends Callback>> callbackTypes;
    private final AdvisableHelper<Callback> advisableHelper;
    private final Set<Class<? extends Event>> eventTypes;
    private final ObservableHelper<Event> observable;

    @SafeVarargs
    public LocalServiceConnection(Class<? extends Event> ... eventTypes) {
        this.callbackTypes = Set.of();
        this.eventTypes = Set.of(eventTypes);
        this.advisableHelper = new AdvisableHelper();
        this.observable = new ObservableHelper();
    }

    public LocalServiceConnection(Set<Class<? extends Callback>> callbackTypes, Set<Class<? extends Event>> eventTypes) {
        this.callbackTypes = callbackTypes;
        this.eventTypes = eventTypes;
        this.advisableHelper = new AdvisableHelper();
        this.observable = new ObservableHelper();
    }

    @Override
    public <T> boolean canSetCallback(Class<T> paramsClass) {
        for (Class<? extends Callback> callbackType : this.callbackTypes) {
            Class callbackRequestClass = ParamsType.from(CallbackType.of(callbackType)).type();
            if (!paramsClass.equals(callbackRequestClass)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T> boolean canSubscribe(Class<T> eventClass) {
        for (Class<? extends Event> eventType : this.eventTypes) {
            if (!eventType.equals(EventType.from(eventClass).type())) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T extends Event> SubscriptionImpl on(Class<T> eventClass, Observer<T> observer) {
        return this.observable.on(eventClass, observer);
    }

    @Override
    public <T extends Event> void dispatch(T event) {
        this.observable.notifyObservers(event);
    }

    @Override
    public <C extends Callback> C set(Class<C> callbackClass, C callback) {
        return (C)((Callback)this.advisableHelper.put(callbackClass, callback));
    }

    @Override
    public <C extends Callback> Optional<C> get(Class<C> callbackClass) {
        return this.advisableHelper.get(callbackClass);
    }

    @Override
    public <C extends Callback> C remove(Class<C> callbackClass) {
        return (C)((Callback)this.advisableHelper.remove(callbackClass));
    }

    @Override
    public <T extends Message> void setCallbackInterceptor(Class<T> messageClass, Interceptor<T> interceptor) {
        throw new UnsupportedOperationException("Cannot set an interceptor on a local service connection.");
    }

    @Override
    public <T extends Message> void setEventInterceptor(Class<T> messageClass, Interceptor<T> interceptor) {
        throw new UnsupportedOperationException("Cannot set an interceptor on a local service connection.");
    }

    @Override
    public FakeService stub() {
        return new FakeService();
    }

    @Override
    public <RequestT extends Message, ResponseT extends Message> ResponseT invoke(ServiceMethod<RequestT, ResponseT> method, RequestT request) {
        throw new UnsupportedOperationException("Cannot invoke a method on a local service connection.");
    }

    @Override
    public <RequestT extends Message, ResponseT extends Message> void invokeAsync(ServiceMethod<RequestT, ResponseT> method, RequestT request, RpcCallback<ResponseT> done) {
        throw new UnsupportedOperationException("Cannot invoke a method on a local service connection.");
    }

    @Override
    public <RequestT extends Message, ResponseT extends Message> void invokeAsync(ServiceMethod<RequestT, ResponseT> method, RequestT request) {
        throw new UnsupportedOperationException("Cannot invoke a method on a local service connection.");
    }

    public static class FakeService
    implements Service {
        @Override
        @Nullable
        public Descriptors.ServiceDescriptor descriptorForType() {
            return null;
        }

        @Override
        @Nullable
        public Message requestPrototype(Descriptors.MethodDescriptor method) {
            return null;
        }

        @Override
        @Nullable
        public Message responsePrototype(Descriptors.MethodDescriptor method) {
            return null;
        }

        @Override
        public Optional<Descriptors.MethodDescriptor> methodDescriptor(Class<?> cls) {
            return Optional.empty();
        }
    }
}

