/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal.rpc;

import com.teamdev.jxbrowser.ObjectClosedException;
import com.teamdev.jxbrowser.callback.Callback;
import com.teamdev.jxbrowser.deps.com.google.protobuf.Descriptors;
import com.teamdev.jxbrowser.deps.com.google.protobuf.Message;
import com.teamdev.jxbrowser.deps.com.google.protobuf.RpcChannel;
import com.teamdev.jxbrowser.event.Event;
import com.teamdev.jxbrowser.event.Observer;
import com.teamdev.jxbrowser.event.internal.SubscriptionImpl;
import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.internal.rpc.Service;
import com.teamdev.jxbrowser.internal.rpc.ServiceChannel;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnection;
import com.teamdev.jxbrowser.internal.rpc.ServiceMethod;
import com.teamdev.jxbrowser.internal.rpc.stream.CallbackStream;
import com.teamdev.jxbrowser.internal.rpc.stream.EventStream;
import com.teamdev.jxbrowser.internal.rpc.stream.Interceptor;
import com.teamdev.jxbrowser.internal.rpc.stream.util.CallbackType;
import com.teamdev.jxbrowser.internal.rpc.stream.util.EventType;
import com.teamdev.jxbrowser.internal.rpc.stream.util.MessageType;
import com.teamdev.jxbrowser.internal.rpc.stream.util.ParamsType;
import com.teamdev.jxbrowser.internal.rpc.transport.Connection;
import com.teamdev.jxbrowser.internal.rpc.transport.RpcCallExecutor;
import com.teamdev.jxbrowser.internal.rpc.transport.RpcCallback;
import com.teamdev.jxbrowser.internal.rpc.transport.SharedMemoryController;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

public final class ServiceConnectionImpl<StubT extends Service>
implements ServiceConnection<StubT> {
    private final Message targetId;
    private final StubT stub;
    private final Connection connection;
    private final Map<Class<?>, EventStream> eventStreams;
    private final Map<Class<?>, CallbackStream> callbackStreams;

    public ServiceConnectionImpl(Message targetId, Connection connection, StubFactory<StubT> stubFactoryMethod) {
        this.connection = connection;
        this.stub = (Service)stubFactoryMethod.newStub(new ServiceChannel(connection));
        this.targetId = targetId;
        this.eventStreams = new ConcurrentHashMap();
        this.callbackStreams = new ConcurrentHashMap();
    }

    @Override
    public <T extends Event> SubscriptionImpl on(Class<T> eventClass, Observer<T> observer) {
        Preconditions.checkNotNull(eventClass);
        Preconditions.checkNotNull(observer);
        EventStream stream = this.eventStreams.computeIfAbsent(this.toEventType(eventClass), cls -> this.stub.methodDescriptor(eventClass).map(this::newEventStream).orElse(null));
        if (stream != null) {
            return stream.on(observer);
        }
        throw new IllegalArgumentException("Unsupported event type: " + String.valueOf(eventClass));
    }

    private EventStream newEventStream(Descriptors.MethodDescriptor methodDescriptor) {
        return new EventStream((Service)this.stub, methodDescriptor, this.targetId, this.connection);
    }

    private <T> Class<?> toEventType(Class<T> eventClass) {
        return EventType.from(eventClass).type();
    }

    @Override
    public <T extends Event> void dispatch(T event) {
        Preconditions.checkNotNull(event);
        Class<?> eventClass = event.getClass();
        Optional.ofNullable(this.eventStreams.get(this.toEventType(eventClass))).ifPresent(eventStream -> eventStream.dispatch(event));
    }

    @Override
    public <T> boolean canSetCallback(Class<T> paramsClass) {
        Preconditions.checkNotNull(paramsClass);
        return this.stub.methodDescriptor(paramsClass).isPresent();
    }

    @Override
    public <T> boolean canSubscribe(Class<T> eventClass) {
        Preconditions.checkNotNull(eventClass);
        return this.stub.methodDescriptor(this.toEventType(eventClass)).isPresent();
    }

    @Override
    public <C extends Callback> C set(Class<C> callbackClass, C callback) {
        Preconditions.checkNotNull(callbackClass);
        Preconditions.checkNotNull(callback);
        Class<?> requestClass = this.toRequestClass(callbackClass);
        CallbackStream stream = this.callbackStreams.computeIfAbsent(requestClass, cls -> this.stub.methodDescriptor(requestClass).map(this::newCallbackStream).orElse(null));
        if (stream != null) {
            return stream.set(callbackClass, callback);
        }
        throw new IllegalArgumentException("Unsupported callback type: " + String.valueOf(callbackClass));
    }

    private CallbackStream newCallbackStream(Descriptors.MethodDescriptor methodDescriptor) {
        return new CallbackStream((Service)this.stub, methodDescriptor, this.targetId, this.connection);
    }

    private <C extends Callback> Class<?> toRequestClass(Class<C> callbackClass) {
        CallbackType<C> callbackType = CallbackType.of(callbackClass);
        return ParamsType.from(callbackType).type();
    }

    @Nullable
    private CallbackStream callbackStream(Class<?> requestClass) {
        return this.callbackStreams.get(requestClass);
    }

    @Override
    public <C extends Callback> Optional<C> get(Class<C> callbackClass) {
        Preconditions.checkNotNull(callbackClass);
        Class<?> requestClass = this.toRequestClass(callbackClass);
        return Optional.ofNullable(this.callbackStream(requestClass)).map(CallbackStream::get);
    }

    @Override
    public <C extends Callback> C remove(Class<C> callbackClass) {
        Preconditions.checkNotNull(callbackClass);
        Class<?> requestClass = this.toRequestClass(callbackClass);
        Optional<Callback> callback = Optional.ofNullable(this.callbackStream(requestClass)).filter(stream -> !stream.isClosed()).map(CallbackStream::remove);
        return (C)((Callback)callback.orElse(null));
    }

    @Override
    public <T extends Message> void setCallbackInterceptor(Class<T> messageClass, Interceptor<T> interceptor) {
        Preconditions.checkNotNull(messageClass);
        Preconditions.checkNotNull(interceptor);
        Class<Object> paramsClass = this.toParamType(messageClass);
        CallbackStream stream = this.callbackStreams.computeIfAbsent(paramsClass, cls -> this.stub.methodDescriptor(paramsClass).map(this::newCallbackStream).orElse(null));
        if (stream != null) {
            stream.setInterceptor(interceptor);
            return;
        }
        throw new IllegalArgumentException("The params type is not supported: " + String.valueOf(paramsClass));
    }

    private <T extends Message> Class<Object> toParamType(Class<T> messageClass) {
        MessageType<T> messageType = MessageType.of(messageClass);
        return ParamsType.from(messageType).type();
    }

    @Override
    public <T extends Message> void setEventInterceptor(Class<T> messageClass, Interceptor<T> interceptor) {
        Preconditions.checkNotNull(messageClass);
        Preconditions.checkNotNull(interceptor);
        Class<?> eventClass = this.toEventType(messageClass);
        EventStream stream = this.eventStreams.computeIfAbsent(eventClass, cls -> this.stub.methodDescriptor(eventClass).map(this::newEventStream).orElse(null));
        if (stream != null) {
            stream.setInterceptor(interceptor);
            return;
        }
        throw new IllegalArgumentException("The event type is not supported: " + String.valueOf(messageClass));
    }

    @Override
    public StubT stub() {
        return this.stub;
    }

    @Override
    public void close() {
        for (EventStream eventStream : this.eventStreams.values()) {
            eventStream.close();
        }
        for (CallbackStream callbackStream : this.callbackStreams.values()) {
            callbackStream.close();
        }
        this.eventStreams.clear();
        this.callbackStreams.clear();
    }

    @Override
    public boolean isClosed() {
        return this.connection().isClosed();
    }

    public Connection connection() {
        return this.connection;
    }

    @Override
    public <RequestT extends Message, ResponseT extends Message> ResponseT invoke(ServiceMethod<RequestT, ResponseT> method, RequestT request) {
        this.checkNotClosed();
        RpcCallExecutor callExecutor = RpcCallExecutor.newInstance();
        return callExecutor.execute(request, method);
    }

    @Override
    public <RequestT extends Message, ResponseT extends Message> void invokeAsync(ServiceMethod<RequestT, ResponseT> method, RequestT request, RpcCallback<ResponseT> done) {
        this.checkNotClosed();
        SharedMemoryController controller = new SharedMemoryController();
        method.run(controller, request, response -> this.connection().rpcThread().submit(() -> {
            if (controller.failed()) {
                done.onError(new IllegalStateException(controller.errorText()));
            } else {
                done.onNext((Object)response);
            }
        }));
    }

    @Override
    public <RequestT extends Message, ResponseT extends Message> void invokeAsync(ServiceMethod<RequestT, ResponseT> method, RequestT request) {
        this.checkNotClosed();
        this.invokeAsync(method, request, new RpcCallback<ResponseT>(){});
    }

    private void checkNotClosed() {
        if (this.isClosed()) {
            throw new ObjectClosedException();
        }
    }

    @FunctionalInterface
    public static interface StubFactory<StubT> {
        public StubT newStub(RpcChannel var1);
    }
}

