/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal.rpc.transport;

import com.teamdev.jxbrowser.event.Observer;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.event.internal.ObservableHelper;
import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.internal.RpcThreadImpl;
import com.teamdev.jxbrowser.internal.rpc.ConnectionId;
import com.teamdev.jxbrowser.internal.rpc.ConnectionType;
import com.teamdev.jxbrowser.internal.rpc.RpcRequest;
import com.teamdev.jxbrowser.internal.rpc.RpcResponse;
import com.teamdev.jxbrowser.internal.rpc.StreamData;
import com.teamdev.jxbrowser.internal.rpc.event.ConnectionClosed;
import com.teamdev.jxbrowser.internal.rpc.event.ConnectionEvent;
import com.teamdev.jxbrowser.internal.rpc.stream.StreamChannel;
import com.teamdev.jxbrowser.internal.rpc.stream.StreamObserver;
import com.teamdev.jxbrowser.internal.rpc.transport.Connection;
import com.teamdev.jxbrowser.internal.rpc.transport.RpcCallback;
import com.teamdev.jxbrowser.internal.rpc.transport.RpcThread;
import com.teamdev.jxbrowser.internal.rpc.transport.SharedMemoryTransport;
import javax.annotation.ParametersAreNonnullByDefault;

final class RpcConnection
implements Connection {
    private final ConnectionId id;
    private final SharedMemoryTransport transport;
    private final ObservableHelper<ConnectionEvent> observable;
    private final RpcThread rpcThread;

    RpcConnection(SharedMemoryTransport transport) {
        Preconditions.checkNotNull(transport);
        this.transport = transport;
        this.observable = new ObservableHelper();
        this.rpcThread = new RpcThreadImpl(transport);
        this.id = ConnectionId.newBuilder().setUuid(transport.id()).build();
    }

    @Override
    public void close() {
        if (this.isClosed()) {
            return;
        }
        this.transport.close();
        this.rpcThread.close();
        this.observable.notifyObservers(new ConnectionClosed(this));
    }

    @Override
    public boolean isClosed() {
        return this.transport.isClosed();
    }

    @Override
    @ParametersAreNonnullByDefault
    public <E extends ConnectionEvent> Subscription on(Class<E> eventClass, Observer<E> observer) {
        return this.observable.on(eventClass, observer);
    }

    @Override
    public ConnectionId id() {
        return this.id;
    }

    @Override
    public ConnectionType type() {
        return this.transport.type();
    }

    @Override
    public void send(RpcRequest request, RpcCallback<RpcResponse> callback) {
        this.transport.send(request, callback);
    }

    @Override
    public StreamChannel openChannel(String serviceName, String methodName, StreamObserver<StreamData> observer) {
        return this.transport.openChannel(serviceName, methodName, observer);
    }

    @Override
    public RpcThread rpcThread() {
        return this.rpcThread;
    }

    public String toString() {
        return "RpcConnection [id = " + this.id.getUuid() + "; type = " + String.valueOf(this.transport.type()) + "]";
    }
}

