/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal.xz;

import com.teamdev.jxbrowser.engine.ChromiumBinariesDeliveryException;
import com.teamdev.jxbrowser.internal.Files;
import com.teamdev.jxbrowser.internal.JniLibrary;
import com.teamdev.jxbrowser.internal.JniLibraryName;
import com.teamdev.jxbrowser.internal.xz.JavaResourceExtractor;
import com.teamdev.jxbrowser.internal.xz.ResourceLocator;
import com.teamdev.jxbrowser.internal.xz.SevenZip;
import com.teamdev.jxbrowser.logging.Logger;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;

public final class ToolkitLibraryExtractor {
    private ToolkitLibraryExtractor() {
    }

    public static void extractTo(Path destDir) {
        if (SevenZip.shouldUseNativeExtraction()) {
            ToolkitLibraryExtractor.extract(destDir);
        }
    }

    private static void extract(Path destDir) {
        Files.createDirs(destDir);
        JavaResourceExtractor extractor = new JavaResourceExtractor();
        JniLibraryName toolkitLibName = JniLibraryName.TOOLKIT;
        Path toolkitLibraryDest = destDir.resolve(toolkitLibName.toPlatform());
        String fileName = toolkitLibName.toPlatform();
        Logger.debug("Extracting {0}", fileName);
        try {
            if (ResourceLocator.findResource(fileName).isEmpty()) {
                throw new ChromiumBinariesDeliveryException(new FileNotFoundException("No JAR file with the platform binaries in the classpath."));
            }
            extractor.extract(fileName, toolkitLibraryDest);
            JniLibrary.path(destDir);
        }
        catch (IOException e) {
            throw new ChromiumBinariesDeliveryException(e);
        }
    }
}

