/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.js.internal;

import com.teamdev.jxbrowser.frame.internal.FrameImpl;
import com.teamdev.jxbrowser.frame.internal.PageContext;
import com.teamdev.jxbrowser.frame.internal.rpc.CreatePromiseResponse;
import com.teamdev.jxbrowser.frame.internal.rpc.PageContextStub;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.internal.rpc.JsObjectId;
import com.teamdev.jxbrowser.internal.rpc.JsObjectProxyId;
import com.teamdev.jxbrowser.internal.rpc.JsSymbolId;
import com.teamdev.jxbrowser.internal.rpc.OwnedJsPromiseId;
import com.teamdev.jxbrowser.internal.rpc.PageContextId;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.internal.rpc.transport.Connection;
import com.teamdev.jxbrowser.js.JsSymbol;
import com.teamdev.jxbrowser.js.internal.JsAccessibleMethod;
import com.teamdev.jxbrowser.js.internal.JsAccessibleObject;
import com.teamdev.jxbrowser.js.internal.JsAccessibleObjects;
import com.teamdev.jxbrowser.js.internal.JsObjectImpl;
import com.teamdev.jxbrowser.js.internal.JsPromiseImpl;
import com.teamdev.jxbrowser.js.internal.JsSymbolImpl;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public final class JsContext
extends CloseableImpl {
    private final FrameImpl frame;
    private final PageContext pageContext;
    private final JsAccessibleObjects jsAccessibleObjects;
    private final Map<JsObjectId, JsObjectImpl> jsObjects;
    private final Map<JsSymbolId, JsSymbolImpl> jsSymbols;
    private final ServiceConnectionImpl<PageContextStub> pageContextRpc;

    private JsContext(FrameImpl frame, PageContext pageContext) {
        this.frame = frame;
        this.pageContextRpc = new ServiceConnectionImpl<PageContextStub>(pageContext.id(), this.connection(), PageContextStub::new);
        this.jsObjects = new ConcurrentHashMap<JsObjectId, JsObjectImpl>();
        this.jsSymbols = new ConcurrentHashMap<JsSymbolId, JsSymbolImpl>();
        this.pageContext = pageContext;
        this.jsAccessibleObjects = new JsAccessibleObjects();
    }

    public static JsContext of(PageContextId pageContextId) {
        return Optional.ofNullable(PageContext.of(pageContextId)).map(PageContext::jsContext).orElseThrow(IllegalStateException::new);
    }

    public static JsContext newInstance(FrameImpl frame, PageContext pageContext) {
        Preconditions.checkNotNull(frame);
        Preconditions.checkNotNull(pageContext);
        return new JsContext(frame, pageContext);
    }

    public void registerJsObject(JsObjectImpl jsObject) {
        this.jsObjects.put(jsObject.objectId(), jsObject);
    }

    public void registerJsSymbol(JsSymbolImpl jsSymbol) {
        this.jsSymbols.put(jsSymbol.id(), jsSymbol);
    }

    public Optional<JsSymbol> findJsSymbol(JsSymbolId id) {
        return Optional.ofNullable((JsSymbol)this.jsSymbols.get(id));
    }

    public <T> Optional<T> findJsObject(JsObjectId id, Class<T> objectType) {
        JsObjectImpl jsObject = this.jsObjects.get(id);
        if (jsObject != null) {
            Preconditions.checkState(objectType.isAssignableFrom(jsObject.getClass()));
        }
        return Optional.ofNullable(jsObject);
    }

    public FrameImpl frame() {
        return this.frame;
    }

    PageContext pageContext() {
        return this.pageContext;
    }

    @Override
    public void close() {
        this.jsObjects.forEach((jsObjectId, jsObject) -> jsObject.makeClosed());
        this.jsSymbols.forEach((jsSymbolId, jsSymbol) -> jsSymbol.close());
        this.jsAccessibleObjects.close();
        super.close();
    }

    public void onObjectClosed(JsObjectId id) {
        this.jsObjects.remove(id);
    }

    public Optional<JsAccessibleObject> jsAccessibleObject(JsObjectProxyId proxyId) {
        return this.jsAccessibleObjects.getJavaObject(proxyId);
    }

    <T> JsPromiseImpl convertToPromise(CompletableFuture<T> future) {
        Preconditions.checkNotNull(future);
        CreatePromiseResponse response = (CreatePromiseResponse)this.pageContextRpc.invoke(this.pageContextRpc.stub()::createPromise, this.pageContext.id());
        if (response.hasPageContextNotFound()) {
            throw new IllegalStateException("The page context is not found.");
        }
        OwnedJsPromiseId promiseId = response.getId();
        JsPromiseImpl associatedJsPromise = new JsPromiseImpl(this, promiseId);
        this.registerJsObject(associatedJsPromise);
        future.whenCompleteAsync((futureResult, throwable) -> {
            if (throwable != null) {
                String errorMessage = throwable.getStackTrace().length > 0 ? String.format("%s in %s", throwable, throwable.getStackTrace()[0]) : throwable.toString();
                associatedJsPromise.reject(errorMessage);
            } else {
                associatedJsPromise.resolve(futureResult);
            }
        });
        return associatedJsPromise;
    }

    JsObjectProxyId registerObject(Object object) {
        return this.registerJavaObject(object, false);
    }

    JsObjectProxyId registerFunction(Object object) {
        return this.registerJavaObject(object, true);
    }

    private JsObjectProxyId registerJavaObject(Object object, boolean isFunction) {
        return this.jsAccessibleObjects.getId(object).orElseGet(() -> {
            JsObjectProxyId id;
            if (isFunction) {
                id = this.frame.createJsProxyFunction();
            } else {
                JsAccessibleObject accessibleObject = new JsAccessibleObject(object);
                Set<String> fields = this.fieldNames(accessibleObject);
                HashSet<String> methods = new HashSet<String>(this.methodNames(accessibleObject));
                methods.removeAll(fields);
                id = this.frame.createJsProxyObject(fields, methods);
            }
            this.jsAccessibleObjects.add(id, object);
            return id;
        });
    }

    public Connection connection() {
        return this.frame.renderProcess().connection();
    }

    private Set<String> methodNames(JsAccessibleObject object) {
        return object.accessibleMethods().stream().map(JsAccessibleMethod::name).collect(Collectors.toSet());
    }

    private Set<String> fieldNames(JsAccessibleObject object) {
        return object.accessibleFields().stream().map(Field::getName).collect(Collectors.toSet());
    }
}

