/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.navigation;

import com.teamdev.jxbrowser.annotation.Immutable;
import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.internal.string.StringPreconditions;
import com.teamdev.jxbrowser.navigation.internal.rpc.LoadRequest;
import com.teamdev.jxbrowser.net.ByteData;
import com.teamdev.jxbrowser.net.FormData;
import com.teamdev.jxbrowser.net.MultipartFormData;
import com.teamdev.jxbrowser.net.TextData;
import com.teamdev.jxbrowser.net.UploadData;
import com.teamdev.jxbrowser.net.internal.rpc.HttpHeader;
import com.teamdev.jxbrowser.net.internal.rpc.UploadData;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public interface LoadUrlParams {
    public static Builder newBuilder(String url) {
        StringPreconditions.checkNotNullEmptyOrBlank(url);
        return new Builder(url);
    }

    default public String url() {
        return ((LoadRequest)this).getUrl();
    }

    default public Optional<UploadData> uploadData() {
        com.teamdev.jxbrowser.net.internal.rpc.UploadData uploadData = ((LoadRequest)this).getPostData();
        if (uploadData.getDataCase() == UploadData.DataCase.BYTE_DATA) {
            return Optional.of(uploadData.getByteData());
        }
        if (uploadData.getDataCase() == UploadData.DataCase.TEXT_DATA) {
            return Optional.of(uploadData.getTextData());
        }
        if (uploadData.getDataCase() == UploadData.DataCase.FORM_DATA) {
            return Optional.of(uploadData.getFormData());
        }
        if (uploadData.getDataCase() == UploadData.DataCase.MULTIPART_FORM_DATA) {
            return Optional.of(uploadData.getMultipartFormData());
        }
        return Optional.empty();
    }

    @Immutable
    default public List<com.teamdev.jxbrowser.net.HttpHeader> extraHeaders() {
        return Collections.unmodifiableList(((LoadRequest)this).getHttpHeaderList());
    }

    public static final class Builder {
        private final LoadRequest.Builder builder;

        private Builder(String url) {
            this.builder = LoadRequest.newBuilder().setUrl(url);
        }

        public Builder uploadData(ByteData data) {
            Preconditions.checkNotNull(data);
            this.builder.setPostData(com.teamdev.jxbrowser.net.internal.rpc.UploadData.newBuilder().setByteData(com.teamdev.jxbrowser.net.internal.rpc.ByteData.cast(data)).build());
            return this;
        }

        public Builder uploadData(TextData data) {
            Preconditions.checkNotNull(data);
            this.builder.setPostData(com.teamdev.jxbrowser.net.internal.rpc.UploadData.newBuilder().setTextData(com.teamdev.jxbrowser.net.internal.rpc.TextData.cast(data)).build());
            return this;
        }

        public Builder uploadData(FormData data) {
            Preconditions.checkNotNull(data);
            this.builder.setPostData(com.teamdev.jxbrowser.net.internal.rpc.UploadData.newBuilder().setFormData(com.teamdev.jxbrowser.net.internal.rpc.FormData.cast(data)).build());
            return this;
        }

        public Builder uploadData(MultipartFormData data) {
            Preconditions.checkNotNull(data);
            this.builder.setPostData(com.teamdev.jxbrowser.net.internal.rpc.UploadData.newBuilder().setMultipartFormData(com.teamdev.jxbrowser.net.internal.rpc.MultipartFormData.cast(data)).build());
            return this;
        }

        public Builder addExtraHeader(com.teamdev.jxbrowser.net.HttpHeader httpHeader) {
            Preconditions.checkNotNull(httpHeader);
            this.builder.addHttpHeader((HttpHeader)httpHeader);
            return this;
        }

        public LoadUrlParams build() {
            return this.builder.build();
        }
    }
}

