/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.net.internal;

import com.teamdev.jxbrowser.deps.com.google.protobuf.StringValue;
import com.teamdev.jxbrowser.engine.internal.EngineImpl;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.internal.rpc.Protobuf;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.net.HttpAuthPreferences;
import com.teamdev.jxbrowser.net.internal.NetworkImpl;
import com.teamdev.jxbrowser.net.internal.rpc.HttpAuthPreferencesStub;

public class HttpAuthPreferencesImpl
extends CloseableImpl
implements HttpAuthPreferences {
    private final ServiceConnectionImpl<HttpAuthPreferencesStub> rpc;

    HttpAuthPreferencesImpl(NetworkImpl network) {
        EngineImpl engine = network.profile().engine();
        this.rpc = new ServiceConnectionImpl<HttpAuthPreferencesStub>(engine.id(), engine.connection(), HttpAuthPreferencesStub::new);
    }

    @Override
    public String serverWhitelist() {
        this.checkNotClosed();
        return ((StringValue)this.rpc.invoke(this.rpc.stub()::getServerWhitelist, Protobuf.empty())).getValue();
    }

    @Override
    public void serverWhitelist(String serverWhitelist) {
        Preconditions.checkNotNull(serverWhitelist);
        this.checkNotClosed();
        this.rpc.invoke(this.rpc.stub()::setServerWhitelist, StringValue.of(serverWhitelist));
    }

    @Override
    public String delegateWhitelist() {
        this.checkNotClosed();
        return ((StringValue)this.rpc.invoke(this.rpc.stub()::getDelegateWhitelist, Protobuf.empty())).getValue();
    }

    @Override
    public void delegateWhitelist(String delegateWhitelist) {
        Preconditions.checkNotNull(delegateWhitelist);
        this.checkNotClosed();
        this.rpc.invoke(this.rpc.stub()::setDelegateWhitelist, StringValue.of(delegateWhitelist));
    }
}

