/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.net.internal;

import com.teamdev.jxbrowser.deps.com.google.protobuf.StringValue;
import com.teamdev.jxbrowser.event.Observer;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.Lazy;
import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.internal.rpc.UniversalServiceConnection;
import com.teamdev.jxbrowser.internal.rpc.transport.Connection;
import com.teamdev.jxbrowser.internal.string.StringPreconditions;
import com.teamdev.jxbrowser.net.HttpAuthPreferences;
import com.teamdev.jxbrowser.net.Network;
import com.teamdev.jxbrowser.net.UrlRequestJob;
import com.teamdev.jxbrowser.net.callback.NetworkCallback;
import com.teamdev.jxbrowser.net.event.NetworkEvent;
import com.teamdev.jxbrowser.net.internal.HttpAuthPreferencesImpl;
import com.teamdev.jxbrowser.net.internal.InterceptRequestCallbackProxy;
import com.teamdev.jxbrowser.net.internal.UrlRequestJobImpl;
import com.teamdev.jxbrowser.net.internal.callback.InterceptRequestCallback;
import com.teamdev.jxbrowser.net.internal.rpc.CertificateVerifierStub;
import com.teamdev.jxbrowser.net.internal.rpc.NetworkStub;
import com.teamdev.jxbrowser.net.internal.rpc.RequestInterceptorStub;
import com.teamdev.jxbrowser.net.internal.rpc.UrlRequestJobOptions;
import com.teamdev.jxbrowser.profile.internal.ProfileImpl;
import com.teamdev.jxbrowser.profile.internal.rpc.ProfileStub;
import com.teamdev.jxbrowser.profile.internal.rpc.SetAcceptLanguageRequest;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public final class NetworkImpl
extends CloseableImpl
implements Network {
    private final ProfileImpl profile;
    private final UniversalServiceConnection rpc;
    private final Set<UrlRequestJobImpl> urlRequestJobs;
    private final Lazy<HttpAuthPreferencesImpl> httpAuthPreferences;
    private final Connection netConnection;

    public NetworkImpl(ProfileImpl profile) {
        Preconditions.checkNotNull(profile);
        this.profile = profile;
        this.urlRequestJobs = new CopyOnWriteArraySet<UrlRequestJobImpl>();
        this.httpAuthPreferences = new Lazy<HttpAuthPreferencesImpl>(() -> new HttpAuthPreferencesImpl(this));
        Connection connection = profile.engine().connection();
        this.netConnection = profile.engine().netConnection();
        this.rpc = UniversalServiceConnection.with(connection).and(new ServiceConnectionImpl<ProfileStub>(profile.id(), connection, ProfileStub::new)).and(new ServiceConnectionImpl<NetworkStub>(profile.id(), this.netConnection, NetworkStub::new)).and(new ServiceConnectionImpl<CertificateVerifierStub>(profile.id(), this.netConnection, CertificateVerifierStub::new)).and(new ServiceConnectionImpl<RequestInterceptorStub>(profile.id(), this.netConnection, RequestInterceptorStub::new)).build();
    }

    @Override
    public ProfileImpl profile() {
        return this.profile;
    }

    public void initialize() {
        this.rpc.set(InterceptRequestCallback.class, new InterceptRequestCallbackProxy(this, this.profile.engine().options().schemes()));
    }

    @Override
    public void close() {
        this.urlRequestJobs.forEach(CloseableImpl::close);
        NetworkImpl.closeIfNecessary(this.httpAuthPreferences);
        this.rpc.close();
        super.close();
    }

    @Override
    public HttpAuthPreferences httpAuthPreferences() {
        return this.httpAuthPreferences.get();
    }

    @Override
    public String acceptLanguage() {
        this.checkNotClosed();
        return ((StringValue)this.rpc.invoke(this.rpc.stub(ProfileStub.class)::getAcceptLanguage, this.profile.id())).getValue();
    }

    @Override
    public void acceptLanguage(String language) {
        StringPreconditions.checkNotNullEmptyOrBlank(language);
        this.checkNotClosed();
        SetAcceptLanguageRequest request = SetAcceptLanguageRequest.newBuilder().setAcceptLanguage(language).setProfileId(this.profile.id()).build();
        this.rpc.invoke(this.rpc.stub(ProfileStub.class)::setAcceptLanguage, request);
    }

    @Override
    public String userAgent() {
        this.checkNotClosed();
        return ((StringValue)this.rpc.invoke(this.rpc.stub(ProfileStub.class)::getUserAgent, this.profile.id())).getValue();
    }

    UrlRequestJob newUrlRequestJob(UrlRequestJobOptions options) {
        Preconditions.checkNotNull(options);
        this.checkNotClosed();
        UrlRequestJobImpl job = UrlRequestJobImpl.create(options, this.netConnection);
        this.urlRequestJobs.add(job);
        return job;
    }

    @Override
    public <E extends NetworkEvent> Subscription on(Class<E> eventClass, Observer<E> observer) {
        return this.rpc.on(eventClass, observer);
    }

    @Override
    public <C extends NetworkCallback> C set(Class<C> callbackClass, C callback) {
        return (C)((NetworkCallback)this.rpc.set(callbackClass, callback));
    }

    @Override
    public <C extends NetworkCallback> Optional<C> get(Class<C> callbackClass) {
        return this.rpc.get(callbackClass);
    }

    @Override
    public <C extends NetworkCallback> C remove(Class<C> callbackClass) {
        return (C)((NetworkCallback)this.rpc.remove(callbackClass));
    }
}

