/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.net.proxy.internal;

import com.teamdev.jxbrowser.engine.internal.EngineImpl;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.net.internal.rpc.ProxyConfig;
import com.teamdev.jxbrowser.net.internal.rpc.ProxyStub;
import com.teamdev.jxbrowser.net.internal.rpc.SetProxyConfigRequest;
import com.teamdev.jxbrowser.net.proxy.AutoDetectProxyConfig;
import com.teamdev.jxbrowser.net.proxy.CustomProxyConfig;
import com.teamdev.jxbrowser.net.proxy.DirectProxyConfig;
import com.teamdev.jxbrowser.net.proxy.Proxy;
import com.teamdev.jxbrowser.net.proxy.ProxyConfig;
import com.teamdev.jxbrowser.net.proxy.SystemProxyConfig;
import com.teamdev.jxbrowser.net.proxy.UrlProxyConfig;
import com.teamdev.jxbrowser.profile.internal.ProfileImpl;

public final class ProxyImpl
extends CloseableImpl
implements Proxy {
    private final ProfileImpl profile;
    private final ServiceConnectionImpl<ProxyStub> rpc;

    public ProxyImpl(ProfileImpl profile) {
        Preconditions.checkNotNull(profile);
        this.profile = profile;
        EngineImpl engine = profile.engine();
        this.rpc = new ServiceConnectionImpl<ProxyStub>(engine.id(), engine.connection(), ProxyStub::new);
    }

    @Override
    public ProfileImpl profile() {
        return this.profile;
    }

    @Override
    public ProxyConfig config() {
        this.checkNotClosed();
        com.teamdev.jxbrowser.net.internal.rpc.ProxyConfig response = (com.teamdev.jxbrowser.net.internal.rpc.ProxyConfig)this.rpc.invoke(this.rpc.stub()::getConfig, this.profile.id());
        ProxyConfig.Type proxyType = response.getType();
        if (proxyType == ProxyConfig.Type.SYSTEM) {
            return SystemProxyConfig.newInstance();
        }
        if (proxyType == ProxyConfig.Type.AUTO_DETECT) {
            return AutoDetectProxyConfig.newInstance();
        }
        if (proxyType == ProxyConfig.Type.DIRECT) {
            return DirectProxyConfig.newInstance();
        }
        if (proxyType == ProxyConfig.Type.PAC) {
            return UrlProxyConfig.newInstance(response.getAutoConfigUrl());
        }
        if (proxyType == ProxyConfig.Type.CUSTOM) {
            return CustomProxyConfig.newInstance(response.getProxyRules(), response.getProxyExceptions());
        }
        throw new IllegalStateException("Unsupported proxy type: " + String.valueOf(proxyType));
    }

    @Override
    public void config(AutoDetectProxyConfig proxyConfig) {
        this.checkNotClosed();
        Preconditions.checkNotNull(proxyConfig);
        this.applyConfig(this.configBuilder(ProxyConfig.Type.AUTO_DETECT).build());
    }

    @Override
    public void config(CustomProxyConfig proxyConfig) {
        this.checkNotClosed();
        Preconditions.checkNotNull(proxyConfig);
        com.teamdev.jxbrowser.net.internal.rpc.ProxyConfig rpcProxyConfig = this.configBuilder(ProxyConfig.Type.CUSTOM).setProxyRules(proxyConfig.proxyRules()).setProxyExceptions(proxyConfig.exceptions()).build();
        this.applyConfig(rpcProxyConfig);
    }

    @Override
    public void config(DirectProxyConfig proxyConfig) {
        this.checkNotClosed();
        Preconditions.checkNotNull(proxyConfig);
        this.applyConfig(this.configBuilder(ProxyConfig.Type.DIRECT).build());
    }

    @Override
    public void config(SystemProxyConfig proxyConfig) {
        this.checkNotClosed();
        Preconditions.checkNotNull(proxyConfig);
        this.applyConfig(this.configBuilder(ProxyConfig.Type.SYSTEM).build());
    }

    @Override
    public void config(UrlProxyConfig proxyConfig) {
        this.checkNotClosed();
        Preconditions.checkNotNull(proxyConfig);
        com.teamdev.jxbrowser.net.internal.rpc.ProxyConfig rpcProxyConfig = this.configBuilder(ProxyConfig.Type.PAC).setAutoConfigUrl(proxyConfig.proxyAutoConfigFileUrl()).build();
        this.applyConfig(rpcProxyConfig);
    }

    private ProxyConfig.Builder configBuilder(ProxyConfig.Type type) {
        return com.teamdev.jxbrowser.net.internal.rpc.ProxyConfig.newBuilder().setType(type);
    }

    private void applyConfig(com.teamdev.jxbrowser.net.internal.rpc.ProxyConfig rpcProxyConfig) {
        SetProxyConfigRequest request = SetProxyConfigRequest.newBuilder().setProfileId(this.profile.id()).setProxyConfig(rpcProxyConfig).build();
        this.rpc.invoke(this.rpc.stub()::setConfig, request);
    }

    @Override
    public void close() {
        this.rpc.close();
        super.close();
    }
}

