/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.net.tls;

import com.teamdev.jxbrowser.deps.com.google.protobuf.ByteString;
import com.teamdev.jxbrowser.internal.Preconditions;

public interface SslPrivateKey {
    public static SslPrivateKey of(byte[] derEncoded) {
        Preconditions.checkNotNull(derEncoded);
        Preconditions.checkArgument(derEncoded.length > 0, "The DER-encoded representation of the SSL private key cannot be empty.", new Object[0]);
        return com.teamdev.jxbrowser.net.internal.rpc.SslPrivateKey.newBuilder().setDerEncodedValue(ByteString.copyFrom(derEncoded)).build();
    }

    default public byte[] derEncodedValue() {
        return com.teamdev.jxbrowser.net.internal.rpc.SslPrivateKey.cast(this).getDerEncodedValue().toByteArray();
    }
}

