/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.print;

import com.teamdev.jxbrowser.annotation.Immutable;
import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.internal.string.StringPreconditions;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class PaperSize {
    private static final int MICRONS_PER_INCH = 25400;
    private static final int MICRONS_PER_MILLIMETER = 1000;
    public static final PaperSize NA_5X7 = PaperSize.of(5.0f, 7.0f, Unit.INCHES, "5x7");
    public static final PaperSize NA_6X9 = PaperSize.of(6.0f, 9.0f, Unit.INCHES, "6x9");
    public static final PaperSize NA_7X9 = PaperSize.of(7.0f, 9.0f, Unit.INCHES, "7x9");
    public static final PaperSize NA_9X11 = PaperSize.of(9.0f, 11.0f, Unit.INCHES, "9x11");
    public static final PaperSize NA_10X11 = PaperSize.of(10.0f, 11.0f, Unit.INCHES, "10x11");
    public static final PaperSize NA_10X13 = PaperSize.of(10.0f, 13.0f, Unit.INCHES, "10x13");
    public static final PaperSize NA_10X14 = PaperSize.of(10.0f, 14.0f, Unit.INCHES, "10x14");
    public static final PaperSize NA_10X15 = PaperSize.of(10.0f, 15.0f, Unit.INCHES, "10x15");
    public static final PaperSize NA_11X12 = PaperSize.of(11.0f, 12.0f, Unit.INCHES, "11x12");
    public static final PaperSize NA_11X15 = PaperSize.of(11.0f, 15.0f, Unit.INCHES, "11x15");
    public static final PaperSize NA_12X19 = PaperSize.of(12.0f, 19.0f, Unit.INCHES, "12x19");
    public static final PaperSize NA_INDEX_3X5 = PaperSize.of(3.0f, 5.0f, Unit.INCHES, "Index 3x5");
    public static final PaperSize NA_INDEX_4X6 = PaperSize.of(4.0f, 6.0f, Unit.INCHES, "Index 4x6");
    public static final PaperSize NA_INDEX_4X6_EXT = PaperSize.of(6.0f, 8.0f, Unit.INCHES, "Index 4x6 ext");
    public static final PaperSize NA_INDEX_5X8 = PaperSize.of(5.0f, 8.0f, Unit.INCHES, "Index 5x8");
    public static final PaperSize NA_NUMBER_9 = PaperSize.of(3.875f, 8.875f, Unit.INCHES, "Envelope #9");
    public static final PaperSize NA_NUMBER_10 = PaperSize.of(4.125f, 9.5f, Unit.INCHES, "Envelope #10");
    public static final PaperSize NA_NUMBER_11 = PaperSize.of(4.5f, 10.375f, Unit.INCHES, "Envelope #11");
    public static final PaperSize NA_NUMBER_12 = PaperSize.of(4.75f, 11.0f, Unit.INCHES, "Envelope #12");
    public static final PaperSize NA_NUMBER_14 = PaperSize.of(5.0f, 11.5f, Unit.INCHES, "Envelope #14");
    public static final PaperSize NA_PERSONAL = PaperSize.of(3.625f, 6.5f, Unit.INCHES, "Personal");
    public static final PaperSize NA_MONARCH = PaperSize.of(3.875f, 7.5f, Unit.INCHES, "Monarch");
    public static final PaperSize NA_INVOICE = PaperSize.of(5.5f, 8.5f, Unit.INCHES, "Invoice");
    public static final PaperSize NA_EXECUTIVE = PaperSize.of(7.25f, 10.5f, Unit.INCHES, "Executive");
    public static final PaperSize NA_GOVT_LETTER = PaperSize.of(8.0f, 10.0f, Unit.INCHES, "Government Letter");
    public static final PaperSize NA_GOVT_LEGAL = PaperSize.of(8.0f, 13.0f, Unit.INCHES, "Government Legal");
    public static final PaperSize NA_QUARTO = PaperSize.of(8.5f, 10.83f, Unit.INCHES, "Quarto");
    public static final PaperSize NA_LETTER = PaperSize.of(8.5f, 11.0f, Unit.INCHES, "Letter");
    public static final PaperSize NA_LETTER_PLUS = PaperSize.of(8.5f, 12.69f, Unit.INCHES, "Letter plus");
    public static final PaperSize NA_LETTER_EXTRA = PaperSize.of(9.5f, 12.0f, Unit.INCHES, "Letter extra");
    public static final PaperSize NA_LEGAL = PaperSize.of(8.5f, 14.0f, Unit.INCHES, "Legal");
    public static final PaperSize NA_LEGAL_EXTRA = PaperSize.of(9.5f, 15.0f, Unit.INCHES, "Legal extra");
    public static final PaperSize NA_FANFOLD_EUR = PaperSize.of(8.5f, 12.0f, Unit.INCHES, "FanFold European");
    public static final PaperSize NA_FOOLSCAP = PaperSize.of(8.5f, 13.0f, Unit.INCHES, "FanFold German Legal");
    public static final PaperSize NA_FANFOLD_US = PaperSize.of(11.0f, 14.875f, Unit.INCHES, "FanFold US");
    public static final PaperSize NA_SUPER_A = PaperSize.of(8.94f, 14.0f, Unit.INCHES, "Super A");
    public static final PaperSize NA_SUPER_B = PaperSize.of(13.0f, 19.0f, Unit.INCHES, "Super B");
    public static final PaperSize NA_A2 = PaperSize.of(4.375f, 5.75f, Unit.INCHES, "A2");
    public static final PaperSize NA_ARCH_A = PaperSize.of(9.0f, 12.0f, Unit.INCHES, "Arch A");
    public static final PaperSize NA_ARCH_B = PaperSize.of(12.0f, 18.0f, Unit.INCHES, "Arch B");
    public static final PaperSize NA_ARCH_C = PaperSize.of(18.0f, 24.0f, Unit.INCHES, "Arch C");
    public static final PaperSize NA_ARCH_D = PaperSize.of(24.0f, 36.0f, Unit.INCHES, "Arch D");
    public static final PaperSize NA_ARCH_E = PaperSize.of(36.0f, 48.0f, Unit.INCHES, "Arch E");
    public static final PaperSize NA_C = PaperSize.of(17.0f, 22.0f, Unit.INCHES, "C");
    public static final PaperSize NA_C5 = PaperSize.of(6.5f, 9.5f, Unit.INCHES, "C5");
    public static final PaperSize NA_D = PaperSize.of(22.0f, 34.0f, Unit.INCHES, "D");
    public static final PaperSize NA_E = PaperSize.of(34.0f, 44.0f, Unit.INCHES, "E");
    public static final PaperSize NA_F = PaperSize.of(44.0f, 68.0f, Unit.INCHES, "F");
    public static final PaperSize NA_EDP = PaperSize.of(11.0f, 14.0f, Unit.INCHES, "EDP");
    public static final PaperSize NA_EUR_EDP = PaperSize.of(12.0f, 14.0f, Unit.INCHES, "European EDP");
    public static final PaperSize NA_LEDGER = PaperSize.of(11.0f, 17.0f, Unit.INCHES, "Tabloid");
    public static final PaperSize NA_B_PLUS = PaperSize.of(12.0f, 19.17f, Unit.INCHES, "B-plus");
    public static final PaperSize NA_ASME_F = PaperSize.of(28.0f, 40.0f, Unit.INCHES, "ASME F");
    public static final PaperSize NA_WIDE_FORMAT = PaperSize.of(30.0f, 42.0f, Unit.INCHES, "Wide format");
    public static final PaperSize PRC_1 = PaperSize.of(102.0f, 165.0f, Unit.MILLIMETERS, "prc1 Envelope");
    public static final PaperSize PRC_2 = PaperSize.of(102.0f, 176.0f, Unit.MILLIMETERS, "prc2 Envelope");
    public static final PaperSize PRC_3 = PaperSize.of(125.0f, 176.0f, Unit.MILLIMETERS, "prc3 Envelope");
    public static final PaperSize PRC_4 = PaperSize.of(110.0f, 208.0f, Unit.MILLIMETERS, "prc4 Envelope");
    public static final PaperSize PRC_5 = PaperSize.of(110.0f, 220.0f, Unit.MILLIMETERS, "prc5 Envelope");
    public static final PaperSize PRC_6 = PaperSize.of(120.0f, 230.0f, Unit.MILLIMETERS, "prc6 Envelope");
    public static final PaperSize PRC_7 = PaperSize.of(160.0f, 230.0f, Unit.MILLIMETERS, "prc7 Envelope");
    public static final PaperSize PRC_8 = PaperSize.of(120.0f, 309.0f, Unit.MILLIMETERS, "prc8 Envelope");
    public static final PaperSize PRC_10 = PaperSize.of(324.0f, 458.0f, Unit.MILLIMETERS, "prc10 Envelope");
    public static final PaperSize PRC_16K = PaperSize.of(146.0f, 215.0f, Unit.MILLIMETERS, "prc 16k");
    public static final PaperSize PRC_32K = PaperSize.of(97.0f, 151.0f, Unit.MILLIMETERS, "prc 32K");
    public static final PaperSize ROC_8K = PaperSize.of(10.75f, 15.5f, Unit.INCHES, "ROC 8K");
    public static final PaperSize ROC_16K = PaperSize.of(7.75f, 10.75f, Unit.INCHES, "ROC 16K");
    public static final PaperSize OM_JUURO_KU_KAI = PaperSize.of(198.0f, 275.0f, Unit.MILLIMETERS, "Juuro-ku-kai");
    public static final PaperSize OM_PA_KAI = PaperSize.of(267.0f, 389.0f, Unit.MILLIMETERS, "Pa-kai");
    public static final PaperSize OM_DAI_PA_KAI = PaperSize.of(275.0f, 395.0f, Unit.MILLIMETERS, "Dai-pa-kai");
    public static final PaperSize ISO_A0 = PaperSize.of(841.0f, 1189.0f, Unit.MILLIMETERS, "A0");
    public static final PaperSize ISO_A1 = PaperSize.of(594.0f, 841.0f, Unit.MILLIMETERS, "A1");
    public static final PaperSize ISO_A2 = PaperSize.of(420.0f, 594.0f, Unit.MILLIMETERS, "A2");
    public static final PaperSize ISO_A3 = PaperSize.of(297.0f, 420.0f, Unit.MILLIMETERS, "A3");
    public static final PaperSize ISO_A3_EXTRA = PaperSize.of(322.0f, 445.0f, Unit.MILLIMETERS, "A3 Extra");
    public static final PaperSize ISO_A4 = PaperSize.of(210.0f, 297.0f, Unit.MILLIMETERS, "A4");
    public static final PaperSize ISO_A4_TAB = PaperSize.of(225.0f, 297.0f, Unit.MILLIMETERS, "A4 Tab");
    public static final PaperSize ISO_A4_EXTRA = PaperSize.of(235.0f, 322.0f, Unit.MILLIMETERS, "A4 Extra");
    public static final PaperSize ISO_A5 = PaperSize.of(148.0f, 210.0f, Unit.MILLIMETERS, "A5");
    public static final PaperSize ISO_A5_EXTRA = PaperSize.of(174.0f, 235.0f, Unit.MILLIMETERS, "A5 Extra");
    public static final PaperSize ISO_A6 = PaperSize.of(105.0f, 148.0f, Unit.MILLIMETERS, "A6");
    public static final PaperSize ISO_A7 = PaperSize.of(74.0f, 105.0f, Unit.MILLIMETERS, "A7");
    public static final PaperSize ISO_A8 = PaperSize.of(52.0f, 74.0f, Unit.MILLIMETERS, "A8");
    public static final PaperSize ISO_A9 = PaperSize.of(37.0f, 52.0f, Unit.MILLIMETERS, "A9");
    public static final PaperSize ISO_A10 = PaperSize.of(26.0f, 37.0f, Unit.MILLIMETERS, "A10");
    public static final PaperSize ISO_A4X3 = PaperSize.of(297.0f, 630.0f, Unit.MILLIMETERS, "A4x3");
    public static final PaperSize ISO_A4X4 = PaperSize.of(297.0f, 841.0f, Unit.MILLIMETERS, "A4x4");
    public static final PaperSize ISO_A4X5 = PaperSize.of(297.0f, 1051.0f, Unit.MILLIMETERS, "A4x5");
    public static final PaperSize ISO_A4X6 = PaperSize.of(297.0f, 1261.0f, Unit.MILLIMETERS, "A4x6");
    public static final PaperSize ISO_A4X7 = PaperSize.of(297.0f, 1471.0f, Unit.MILLIMETERS, "A4x7");
    public static final PaperSize ISO_A4X8 = PaperSize.of(297.0f, 1682.0f, Unit.MILLIMETERS, "A4x8");
    public static final PaperSize ISO_A4X9 = PaperSize.of(297.0f, 1892.0f, Unit.MILLIMETERS, "A4x9");
    public static final PaperSize ISO_A3X3 = PaperSize.of(420.0f, 891.0f, Unit.MILLIMETERS, "A3x3");
    public static final PaperSize ISO_A3X4 = PaperSize.of(420.0f, 1189.0f, Unit.MILLIMETERS, "A3x4");
    public static final PaperSize ISO_A3X5 = PaperSize.of(420.0f, 1486.0f, Unit.MILLIMETERS, "A3x5");
    public static final PaperSize ISO_A3X6 = PaperSize.of(420.0f, 1783.0f, Unit.MILLIMETERS, "A3x6");
    public static final PaperSize ISO_A3X7 = PaperSize.of(420.0f, 2080.0f, Unit.MILLIMETERS, "A3x7");
    public static final PaperSize ISO_A2X3 = PaperSize.of(594.0f, 1261.0f, Unit.MILLIMETERS, "A2x3");
    public static final PaperSize ISO_A2X4 = PaperSize.of(594.0f, 1682.0f, Unit.MILLIMETERS, "A2x4");
    public static final PaperSize ISO_A2X5 = PaperSize.of(594.0f, 2102.0f, Unit.MILLIMETERS, "A2x5");
    public static final PaperSize ISO_A1X3 = PaperSize.of(841.0f, 1783.0f, Unit.MILLIMETERS, "A1x3");
    public static final PaperSize ISO_A1X4 = PaperSize.of(841.0f, 2378.0f, Unit.MILLIMETERS, "A1x4");
    public static final PaperSize ISO_2A0 = PaperSize.of(1189.0f, 1682.0f, Unit.MILLIMETERS, "2A0");
    public static final PaperSize ISO_A0X3 = PaperSize.of(1189.0f, 2523.0f, Unit.MILLIMETERS, "A0x3");
    public static final PaperSize ISO_B0 = PaperSize.of(1000.0f, 1414.0f, Unit.MILLIMETERS, "B0");
    public static final PaperSize ISO_B1 = PaperSize.of(707.0f, 1000.0f, Unit.MILLIMETERS, "B1");
    public static final PaperSize ISO_B2 = PaperSize.of(500.0f, 707.0f, Unit.MILLIMETERS, "B2");
    public static final PaperSize ISO_B3 = PaperSize.of(353.0f, 500.0f, Unit.MILLIMETERS, "B3");
    public static final PaperSize ISO_B4 = PaperSize.of(250.0f, 353.0f, Unit.MILLIMETERS, "B4");
    public static final PaperSize ISO_B5 = PaperSize.of(176.0f, 250.0f, Unit.MILLIMETERS, "B5");
    public static final PaperSize ISO_B5_EXTRA = PaperSize.of(201.0f, 276.0f, Unit.MILLIMETERS, "B5 Extra");
    public static final PaperSize ISO_B6 = PaperSize.of(125.0f, 176.0f, Unit.MILLIMETERS, "B6");
    public static final PaperSize ISO_B6C4 = PaperSize.of(125.0f, 324.0f, Unit.MILLIMETERS, "B6C4");
    public static final PaperSize ISO_B7 = PaperSize.of(88.0f, 125.0f, Unit.MILLIMETERS, "B7");
    public static final PaperSize ISO_B8 = PaperSize.of(62.0f, 88.0f, Unit.MILLIMETERS, "B8");
    public static final PaperSize ISO_B9 = PaperSize.of(44.0f, 62.0f, Unit.MILLIMETERS, "B9");
    public static final PaperSize ISO_B10 = PaperSize.of(31.0f, 44.0f, Unit.MILLIMETERS, "B10");
    public static final PaperSize ISO_C0 = PaperSize.of(917.0f, 1297.0f, Unit.MILLIMETERS, "C0");
    public static final PaperSize ISO_C1 = PaperSize.of(648.0f, 917.0f, Unit.MILLIMETERS, "C1");
    public static final PaperSize ISO_C2 = PaperSize.of(458.0f, 648.0f, Unit.MILLIMETERS, "C2");
    public static final PaperSize ISO_C3 = PaperSize.of(324.0f, 458.0f, Unit.MILLIMETERS, "C3");
    public static final PaperSize ISO_C4 = PaperSize.of(229.0f, 324.0f, Unit.MILLIMETERS, "C4");
    public static final PaperSize ISO_C5 = PaperSize.of(162.0f, 229.0f, Unit.MILLIMETERS, "C5");
    public static final PaperSize ISO_C6 = PaperSize.of(114.0f, 162.0f, Unit.MILLIMETERS, "C6");
    public static final PaperSize ISO_C6C5 = PaperSize.of(114.0f, 229.0f, Unit.MILLIMETERS, "C6C5");
    public static final PaperSize ISO_C7 = PaperSize.of(81.0f, 114.0f, Unit.MILLIMETERS, "C7");
    public static final PaperSize ISO_C7C6 = PaperSize.of(81.0f, 162.0f, Unit.MILLIMETERS, "C7C6");
    public static final PaperSize ISO_C8 = PaperSize.of(57.0f, 81.0f, Unit.MILLIMETERS, "C8");
    public static final PaperSize ISO_C9 = PaperSize.of(40.0f, 57.0f, Unit.MILLIMETERS, "C9");
    public static final PaperSize ISO_C10 = PaperSize.of(28.0f, 40.0f, Unit.MILLIMETERS, "C10");
    public static final PaperSize ISO_DL = PaperSize.of(110.0f, 220.0f, Unit.MILLIMETERS, "DL");
    public static final PaperSize ISO_RA2 = PaperSize.of(430.0f, 610.0f, Unit.MILLIMETERS, "RA2");
    public static final PaperSize ISO_SRA2 = PaperSize.of(450.0f, 640.0f, Unit.MILLIMETERS, "SRA2");
    public static final PaperSize ISO_RA1 = PaperSize.of(610.0f, 860.0f, Unit.MILLIMETERS, "RA1");
    public static final PaperSize ISO_SRA1 = PaperSize.of(640.0f, 900.0f, Unit.MILLIMETERS, "SRA1");
    public static final PaperSize ISO_RA0 = PaperSize.of(860.0f, 1220.0f, Unit.MILLIMETERS, "RA0");
    public static final PaperSize ISO_SRA0 = PaperSize.of(900.0f, 1280.0f, Unit.MILLIMETERS, "SRA0");
    public static final PaperSize JIS_B0 = PaperSize.of(1030.0f, 1456.0f, Unit.MILLIMETERS, "B0 (JIS)");
    public static final PaperSize JIS_B1 = PaperSize.of(728.0f, 1030.0f, Unit.MILLIMETERS, "B1 (JIS)");
    public static final PaperSize JIS_B2 = PaperSize.of(515.0f, 728.0f, Unit.MILLIMETERS, "B2 (JIS)");
    public static final PaperSize JIS_B3 = PaperSize.of(364.0f, 515.0f, Unit.MILLIMETERS, "B3 (JIS)");
    public static final PaperSize JIS_B4 = PaperSize.of(257.0f, 364.0f, Unit.MILLIMETERS, "B4 (JIS)");
    public static final PaperSize JIS_B5 = PaperSize.of(182.0f, 257.0f, Unit.MILLIMETERS, "B5 (JIS)");
    public static final PaperSize JIS_B6 = PaperSize.of(128.0f, 182.0f, Unit.MILLIMETERS, "B6 (JIS)");
    public static final PaperSize JIS_B7 = PaperSize.of(91.0f, 128.0f, Unit.MILLIMETERS, "B7 (JIS)");
    public static final PaperSize JIS_B8 = PaperSize.of(64.0f, 91.0f, Unit.MILLIMETERS, "B8 (JIS)");
    public static final PaperSize JIS_B9 = PaperSize.of(45.0f, 64.0f, Unit.MILLIMETERS, "B9 (JIS)");
    public static final PaperSize JIS_B10 = PaperSize.of(32.0f, 45.0f, Unit.MILLIMETERS, "B10 (JIS)");
    public static final PaperSize JIS_EXEC = PaperSize.of(216.0f, 330.0f, Unit.MILLIMETERS, "Executive (JIS)");
    public static final PaperSize JPN_CHOU2 = PaperSize.of(111.1f, 146.0f, Unit.MILLIMETERS, "Choukei 2");
    public static final PaperSize JPN_CHOU3 = PaperSize.of(120.0f, 235.0f, Unit.MILLIMETERS, "Choukei 3");
    public static final PaperSize JPN_CHOU4 = PaperSize.of(90.0f, 205.0f, Unit.MILLIMETERS, "Choukei 4");
    public static final PaperSize JPN_HAGAKI = PaperSize.of(100.0f, 148.0f, Unit.MILLIMETERS, "Hagaki");
    public static final PaperSize JPN_OUFUKU = PaperSize.of(148.0f, 200.0f, Unit.MILLIMETERS, "Oufuku Hagaki");
    public static final PaperSize JPN_YOU4 = PaperSize.of(105.0f, 235.0f, Unit.MILLIMETERS, "You 4");
    public static final PaperSize JPN_KAHU = PaperSize.of(240.0f, 322.1f, Unit.MILLIMETERS, "Kahu Envelope");
    public static final PaperSize JPN_KAKU2 = PaperSize.of(240.0f, 332.0f, Unit.MILLIMETERS, "Kaku 2");
    public static final PaperSize OM_SMALL_PHOTO = PaperSize.of(100.0f, 150.0f, Unit.MILLIMETERS, "Small photo");
    public static final PaperSize OM_ITALIAN = PaperSize.of(110.0f, 230.0f, Unit.MILLIMETERS, "Italian Envelope");
    public static final PaperSize OM_POSTFIX = PaperSize.of(114.0f, 229.0f, Unit.MILLIMETERS, "Postfix Envelope");
    public static final PaperSize OM_LARGE_PHOTO = PaperSize.of(200.0f, 300.0f, Unit.MILLIMETERS, "Large photo");
    public static final PaperSize OM_FOLIO = PaperSize.of(210.0f, 330.0f, Unit.MILLIMETERS, "Folio");
    public static final PaperSize OM_FOLIO_SP = PaperSize.of(215.0f, 315.0f, Unit.MILLIMETERS, "Folio SP");
    public static final PaperSize OM_INVITE = PaperSize.of(220.0f, 220.0f, Unit.MILLIMETERS, "Invite Envelope");
    private final int width;
    private final int height;
    private final String name;

    public static PaperSize of(float width, float height, Unit unit) {
        PaperSize.checkNonNegative(width, height);
        Preconditions.checkNotNull(unit);
        return new PaperSize(PaperSize.toMicrons(width, unit), PaperSize.toMicrons(height, unit), null);
    }

    public static PaperSize of(float width, float height, Unit unit, String name) {
        PaperSize.checkNonNegative(width, height);
        Preconditions.checkNotNull(unit);
        StringPreconditions.checkNotNullEmptyOrBlank(name);
        return new PaperSize(PaperSize.toMicrons(width, unit), PaperSize.toMicrons(height, unit), name);
    }

    @Immutable
    public static Collection<PaperSize> values() {
        Field[] declaredFields;
        ArrayList<PaperSize> result = new ArrayList<PaperSize>();
        for (Field declaredField : declaredFields = PaperSize.class.getDeclaredFields()) {
            if (!PaperSize.class.equals(declaredField.getType())) continue;
            try {
                result.add((PaperSize)declaredField.get(null));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return List.copyOf(result);
    }

    private PaperSize(int width, int height, @Nullable String name) {
        this.width = width;
        this.height = height;
        this.name = name;
    }

    private static void checkNonNegative(float width, float height) {
        Preconditions.checkArgument(width >= 0.0f, "The paper width must be >= 0.", new Object[0]);
        Preconditions.checkArgument(height >= 0.0f, "The paper height must be >= 0.", new Object[0]);
    }

    private static int toMicrons(float value, Unit unit) {
        if (unit == Unit.MILLIMETERS) {
            return Math.round(value * 1000.0f);
        }
        if (unit == Unit.INCHES) {
            return Math.round(value * 25400.0f);
        }
        return Math.round(value);
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public Optional<String> name() {
        return Optional.ofNullable(this.name);
    }

    public String toString() {
        return String.format("%s [%d x %d]", this.name().orElse("Unknown"), this.width, this.height);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaperSize paperSize = (PaperSize)o;
        return this.width == paperSize.width && this.height == paperSize.height;
    }

    public int hashCode() {
        return Objects.hash(this.width, this.height);
    }

    public static enum Unit {
        MILLIMETERS,
        INCHES,
        MICRONS;

    }
}

