/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.print.internal.settings;

import com.teamdev.jxbrowser.deps.com.google.protobuf.BoolValue;
import com.teamdev.jxbrowser.deps.com.google.protobuf.ProtocolMessageEnum;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.DirectoryCreationException;
import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.internal.rpc.PrintJobId;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnection;
import com.teamdev.jxbrowser.print.Capabilities;
import com.teamdev.jxbrowser.print.ColorModel;
import com.teamdev.jxbrowser.print.DuplexMode;
import com.teamdev.jxbrowser.print.Fit;
import com.teamdev.jxbrowser.print.Orientation;
import com.teamdev.jxbrowser.print.PageMargins;
import com.teamdev.jxbrowser.print.PageRange;
import com.teamdev.jxbrowser.print.PagesPerSheet;
import com.teamdev.jxbrowser.print.PrintSettings;
import com.teamdev.jxbrowser.print.Scaling;
import com.teamdev.jxbrowser.print.internal.PrintTypes;
import com.teamdev.jxbrowser.print.internal.rpc.ApplySettingsRequest;
import com.teamdev.jxbrowser.print.internal.rpc.Collate;
import com.teamdev.jxbrowser.print.internal.rpc.HeaderTemplate;
import com.teamdev.jxbrowser.print.internal.rpc.PdfFilePath;
import com.teamdev.jxbrowser.print.internal.rpc.PrintJobStub;
import com.teamdev.jxbrowser.print.internal.rpc.PrintSettings;
import com.teamdev.jxbrowser.print.internal.rpc.SelectionOnly;
import com.teamdev.jxbrowser.print.internal.settings.PageRanges;
import com.teamdev.jxbrowser.print.internal.settings.PaperSize;
import com.teamdev.jxbrowser.print.settings.Copies;
import com.teamdev.jxbrowser.print.settings.FooterTemplate;
import com.teamdev.jxbrowser.print.settings.PrintBackgrounds;
import com.teamdev.jxbrowser.print.settings.PrintHeaderFooter;
import com.teamdev.jxbrowser.print.settings.PrintSelectionOnly;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.Set;

public abstract class AbstractPrintSettings<T extends PrintSettings>
extends CloseableImpl
implements com.teamdev.jxbrowser.print.settings.Collate<T>,
com.teamdev.jxbrowser.print.settings.ColorModel<T>,
Copies<T>,
com.teamdev.jxbrowser.print.settings.DuplexMode<T>,
com.teamdev.jxbrowser.print.settings.Fit<T>,
FooterTemplate<T>,
com.teamdev.jxbrowser.print.settings.HeaderTemplate<T>,
com.teamdev.jxbrowser.print.settings.Orientation<T>,
com.teamdev.jxbrowser.print.settings.PageMargins<T>,
com.teamdev.jxbrowser.print.settings.PageRanges<T>,
com.teamdev.jxbrowser.print.settings.PagesPerSheet<T>,
com.teamdev.jxbrowser.print.settings.PaperSize<T>,
com.teamdev.jxbrowser.print.settings.PdfFilePath<T>,
PrintBackgrounds<T>,
PrintHeaderFooter<T>,
PrintSelectionOnly<T>,
com.teamdev.jxbrowser.print.settings.Scaling<T> {
    private final PrintJobId printJobId;
    private final ServiceConnection<PrintJobStub> rpc;
    private final Capabilities capabilities;
    private final PrintSettings.Builder builder;
    private com.teamdev.jxbrowser.print.internal.rpc.PrintSettings currentSettings;
    private boolean hasPendingSettings;

    protected AbstractPrintSettings(Capabilities capabilities, PrintJobId printJobId, ServiceConnection<PrintJobStub> rpc, com.teamdev.jxbrowser.print.internal.rpc.PrintSettings defaultSettings) {
        this.capabilities = capabilities;
        this.printJobId = printJobId;
        this.rpc = rpc;
        this.currentSettings = defaultSettings;
        this.builder = this.currentSettings.toBuilder();
        this.hasPendingSettings = true;
    }

    @Override
    public T enableCollatePrinting() {
        Preconditions.checkArgument(this.capabilities.canCollate(), "The printer does not support collate printing.", new Object[0]);
        this.builder.setCollate(Collate.newBuilder().setValue(true).build());
        return (T)((PrintSettings)((Object)this));
    }

    @Override
    public T disableCollatePrinting() {
        this.builder.setCollate(Collate.getDefaultInstance());
        return (T)((PrintSettings)((Object)this));
    }

    @Override
    public T colorModel(ColorModel colorModel) {
        Preconditions.checkNotNull(colorModel);
        Preconditions.checkArgument(this.capabilities.colorModels().contains((Object)colorModel), "The color model is not supported: %s.", new Object[]{colorModel});
        this.builder.setColorModel(com.teamdev.jxbrowser.print.internal.rpc.ColorModel.fromPublic(colorModel));
        return (T)((PrintSettings)((Object)this));
    }

    @Override
    public T copies(int copies) {
        Preconditions.checkArgument(copies >= 1, "The number of copies must be >= 1.", new Object[0]);
        Preconditions.checkArgument(this.capabilities.maxCopies() >= copies, "The printer does not support this number of copies.", new Object[0]);
        this.builder.setCopies(com.teamdev.jxbrowser.print.internal.rpc.Copies.newBuilder().setValue(copies).build());
        return (T)((PrintSettings)((Object)this));
    }

    @Override
    public T duplexMode(DuplexMode duplexMode) {
        Preconditions.checkNotNull(duplexMode);
        Preconditions.checkArgument(this.capabilities.duplexModes().contains((Object)duplexMode), "The printer does not support the duplex mode: %s.", new Object[]{duplexMode});
        this.builder.setDuplexMode(com.teamdev.jxbrowser.print.internal.rpc.DuplexMode.fromPublic(duplexMode));
        return (T)((PrintSettings)((Object)this));
    }

    @Override
    public T pageRanges(Set<PageRange> pageRanges) {
        Preconditions.checkNotNull(pageRanges);
        this.builder.setPageRanges(PrintTypes.cast(PageRanges.from(pageRanges)));
        return (T)((PrintSettings)((Object)this));
    }

    @Override
    public T pageRanges(PageRange ... pageRanges) {
        Preconditions.checkNotNull(pageRanges);
        return this.pageRanges(Set.of(pageRanges));
    }

    @Override
    public T pagesPerSheet(PagesPerSheet pagesPerSheet) {
        Preconditions.checkNotNull(pagesPerSheet);
        com.teamdev.jxbrowser.print.internal.rpc.PagesPerSheet internalPagePerSheet = com.teamdev.jxbrowser.print.internal.rpc.PagesPerSheet.fromPublic(pagesPerSheet);
        AbstractPrintSettings.checkNotUnspecifiedOrUnrecognized(internalPagePerSheet);
        this.builder.setPagesPerSheet(internalPagePerSheet);
        return (T)((PrintSettings)((Object)this));
    }

    @Override
    public T paperSize(com.teamdev.jxbrowser.print.PaperSize paperSize) {
        Preconditions.checkNotNull(paperSize);
        this.builder.setPaperSize(PrintTypes.cast(PaperSize.from(paperSize)));
        return (T)((PrintSettings)((Object)this));
    }

    @Override
    public T pageMargins(PageMargins pageMargins) {
        Preconditions.checkNotNull(pageMargins);
        this.builder.setPageMargins(PrintTypes.cast(pageMargins));
        return (T)((PrintSettings)((Object)this));
    }

    @Override
    public T enablePrintingHeaderFooter() {
        this.builder.setPrintHeaderFooter(com.teamdev.jxbrowser.print.internal.rpc.PrintHeaderFooter.newBuilder().setValue(true).build());
        return (T)((PrintSettings)((Object)this));
    }

    @Override
    public T disablePrintingHeaderFooter() {
        this.builder.setPrintHeaderFooter(com.teamdev.jxbrowser.print.internal.rpc.PrintHeaderFooter.getDefaultInstance());
        return (T)((PrintSettings)((Object)this));
    }

    @Override
    public T orientation(Orientation orientation) {
        Preconditions.checkNotNull(orientation);
        com.teamdev.jxbrowser.print.internal.rpc.Orientation internalOrientation = com.teamdev.jxbrowser.print.internal.rpc.Orientation.fromPublic(orientation);
        AbstractPrintSettings.checkNotUnspecifiedOrUnrecognized(internalOrientation);
        this.builder.setOrientation(internalOrientation);
        return (T)((PrintSettings)((Object)this));
    }

    @Override
    public T enablePrintingBackgrounds() {
        this.builder.setPrintBackgrounds(com.teamdev.jxbrowser.print.internal.rpc.PrintBackgrounds.newBuilder().setValue(true).build());
        return (T)((PrintSettings)((Object)this));
    }

    @Override
    public T disablePrintingBackgrounds() {
        this.builder.setPrintBackgrounds(com.teamdev.jxbrowser.print.internal.rpc.PrintBackgrounds.getDefaultInstance());
        return (T)((PrintSettings)((Object)this));
    }

    @Override
    public T enablePrintingSelectionOnly() {
        this.builder.setSelectionOnly(SelectionOnly.newBuilder().setValue(true).build());
        return (T)((PrintSettings)((Object)this));
    }

    @Override
    public T disablePrintingSelectionOnly() {
        this.builder.setSelectionOnly(SelectionOnly.getDefaultInstance());
        return (T)((PrintSettings)((Object)this));
    }

    @Override
    public T pdfFilePath(Path pdfFilePath) {
        Preconditions.checkNotNull(pdfFilePath);
        Preconditions.checkArgument(pdfFilePath.isAbsolute());
        Preconditions.checkArgument(!Files.isDirectory(pdfFilePath, new LinkOption[0]));
        try {
            com.teamdev.jxbrowser.internal.Files.createDirs(pdfFilePath.getParent());
        }
        catch (DirectoryCreationException e) {
            throw new IllegalArgumentException("The parent directory cannot be created.", e);
        }
        this.builder.setPdfFilePath(PdfFilePath.newBuilder().setValue(pdfFilePath.toString()).build());
        return (T)((PrintSettings)((Object)this));
    }

    @Override
    public T header(String header) {
        Preconditions.checkNotNull(header);
        this.builder.setHeaderTemplate(HeaderTemplate.newBuilder().setValue(header).build());
        return (T)((PrintSettings)((Object)this));
    }

    @Override
    public T footer(String footer) {
        Preconditions.checkNotNull(footer);
        this.builder.setFooterTemplate(com.teamdev.jxbrowser.print.internal.rpc.FooterTemplate.newBuilder().setValue(footer).build());
        return (T)((PrintSettings)((Object)this));
    }

    @Override
    public T scaling(Scaling scaling) {
        Preconditions.checkNotNull(scaling);
        this.builder.setScaling(PrintTypes.cast(scaling));
        return (T)((PrintSettings)((Object)this));
    }

    @Override
    public T fit(Fit fit) {
        Preconditions.checkNotNull(fit);
        com.teamdev.jxbrowser.print.internal.rpc.Fit internalFit = com.teamdev.jxbrowser.print.internal.rpc.Fit.fromPublic(fit);
        AbstractPrintSettings.checkNotUnspecifiedOrUnrecognized(internalFit);
        this.builder.setFit(internalFit);
        return (T)((PrintSettings)((Object)this));
    }

    @Override
    public boolean isCollatePrintingEnabled() {
        return this.currentSettings.getCollate().getValue();
    }

    @Override
    public ColorModel colorModel() {
        return this.currentSettings.getColorModel().toPublic();
    }

    @Override
    public int copies() {
        return this.currentSettings.getCopies().getValue();
    }

    @Override
    public DuplexMode duplexMode() {
        return this.currentSettings.getDuplexMode().toPublic();
    }

    @Override
    public Set<PageRange> pageRanges() {
        return this.currentSettings.getPageRanges().toPublic();
    }

    @Override
    public PagesPerSheet pagesPerSheet() {
        return this.currentSettings.getPagesPerSheet().toPublic();
    }

    @Override
    public com.teamdev.jxbrowser.print.PaperSize paperSize() {
        return this.currentSettings.getPaperSize().toPublic();
    }

    @Override
    public PageMargins pageMargins() {
        return this.currentSettings.getPageMargins();
    }

    @Override
    public boolean isPrintingHeaderFooterEnabled() {
        return this.currentSettings.getPrintHeaderFooter().getValue();
    }

    @Override
    public Orientation orientation() {
        return this.currentSettings.getOrientation().toPublic();
    }

    @Override
    public boolean isPrintingBackgroundsEnabled() {
        return this.currentSettings.getPrintBackgrounds().getValue();
    }

    @Override
    public boolean isPrintingSelectionOnlyEnabled() {
        return this.currentSettings.getSelectionOnly().getValue();
    }

    @Override
    public Optional<Path> pdfFilePath() {
        if (this.currentSettings.hasPdfFilePath()) {
            return Optional.of(Paths.get(this.currentSettings.getPdfFilePath().getValue(), new String[0]));
        }
        return Optional.empty();
    }

    @Override
    public String header() {
        return this.currentSettings.getHeaderTemplate().getValue();
    }

    @Override
    public String footer() {
        return this.currentSettings.getFooterTemplate().getValue();
    }

    @Override
    public Scaling scaling() {
        return this.currentSettings.getScaling();
    }

    @Override
    public Fit fit() {
        return this.currentSettings.getFit().toPublic();
    }

    public com.teamdev.jxbrowser.print.internal.rpc.PrintSettings currentSettings() {
        return this.currentSettings;
    }

    protected void buildSettings() {
        this.currentSettings = this.builder.build();
    }

    public void apply() {
        this.checkNotClosed();
        if (!this.hasPendingSettings) {
            return;
        }
        this.buildSettings();
        BoolValue success = (BoolValue)this.rpc.invoke(this.rpc.stub()::applySettings, this.applySettingsRequest());
        if (!success.getValue()) {
            throw new IllegalArgumentException("Failed to apply the configured settings.");
        }
        this.hasPendingSettings = false;
    }

    private ApplySettingsRequest applySettingsRequest() {
        return ApplySettingsRequest.newBuilder().setPrintJobId(this.printJobId).setSettings(this.currentSettings).build();
    }

    private static void checkNotUnspecifiedOrUnrecognized(ProtocolMessageEnum value) {
        Preconditions.checkArgument(value.getNumber() > 0, "Unsupported value: %s", value);
    }
}

