/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.profile.internal;

import com.teamdev.jxbrowser.engine.internal.EngineImpl;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.internal.rpc.ProfileId;
import com.teamdev.jxbrowser.internal.rpc.Protobuf;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.profile.Profile;
import com.teamdev.jxbrowser.profile.Profiles;
import com.teamdev.jxbrowser.profile.internal.ProfileImpl;
import com.teamdev.jxbrowser.profile.internal.rpc.ProfileList;
import com.teamdev.jxbrowser.profile.internal.rpc.ProfileManagerStub;
import com.teamdev.jxbrowser.profile.internal.rpc.ProfileOptions;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public final class ProfilesImpl
extends CloseableImpl
implements Profiles {
    private final EngineImpl engine;
    private final List<ProfileImpl> list;
    private final ServiceConnectionImpl<ProfileManagerStub> rpc;

    public ProfilesImpl(EngineImpl engine) {
        Preconditions.checkNotNull(engine);
        this.list = new CopyOnWriteArrayList<ProfileImpl>();
        this.engine = engine;
        this.rpc = new ServiceConnectionImpl<ProfileManagerStub>(engine.id(), engine.connection(), ProfileManagerStub::new);
        ((ProfileList)this.rpc.invoke(this.rpc.stub()::getProfiles, Protobuf.empty())).getProfileList().forEach(profileId -> new ProfileImpl(this, (ProfileId)profileId));
    }

    @Override
    public EngineImpl engine() {
        return this.engine;
    }

    @Override
    public List<Profile> list() {
        this.checkNotClosed();
        return List.copyOf(this.list);
    }

    @Override
    public ProfileImpl defaultProfile() {
        this.checkNotClosed();
        for (ProfileImpl profile : this.list) {
            if (!profile.isDefault()) continue;
            return profile;
        }
        throw new IllegalStateException("No default profile found.");
    }

    @Override
    public ProfileImpl newProfile(String name) {
        return this.newProfile(name, false);
    }

    private ProfileImpl newProfile(String name, boolean isIncognito) {
        ProfileOptions options = ProfileOptions.newBuilder().setName(name).setIncognito(isIncognito).build();
        ProfileId profileId = (ProfileId)this.rpc.invoke(this.rpc.stub()::createProfile, options);
        return new ProfileImpl(this, profileId);
    }

    @Override
    public ProfileImpl newIncognitoProfile(String name) {
        return this.newProfile(name, true);
    }

    @Override
    public void delete(Profile profile) {
        this.checkNotClosed();
        Preconditions.checkNotNull(profile);
        ProfileImpl profileImpl = (ProfileImpl)profile;
        if (profileImpl.isClosed()) {
            return;
        }
        Preconditions.checkArgument(!profile.isDefault(), "The default profile cannot be deleted.", new Object[0]);
        profileImpl.close();
        this.rpc.invoke(this.rpc.stub()::deleteProfile, profileImpl.id());
    }

    @Override
    public void close() {
        if (this.isClosed()) {
            return;
        }
        this.list.forEach(ProfileImpl::close);
        this.cleanup();
        super.close();
    }

    public void cleanup() {
        this.list.forEach(ProfileImpl::cleanup);
        this.rpc.close();
    }

    public void register(ProfileImpl profile) {
        if (!this.list.contains(profile)) {
            this.list.add(profile);
        }
    }

    public void unregister(ProfileImpl profile) {
        this.list.remove(profile);
    }
}

