/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.ui.event;

import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.ui.KeyModifiers;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.ui.ScrollType;
import com.teamdev.jxbrowser.ui.event.MouseEvent;
import com.teamdev.jxbrowser.ui.event.MouseEvents;
import com.teamdev.jxbrowser.ui.event.internal.rpc.MouseWheel;

public interface MouseWheel
extends MouseEvent {
    public static Builder newBuilder(Point location) {
        Preconditions.checkNotNull(location);
        return new Builder(location);
    }

    @Override
    default public Point location() {
        return MouseEvents.cast(this).getLocation();
    }

    @Override
    default public Point locationOnScreen() {
        return MouseEvents.cast(this).getLocationOnScreen();
    }

    default public KeyModifiers keyModifiers() {
        return MouseEvents.cast(this).getKeyModifiers();
    }

    default public ScrollType scrollType() {
        return MouseEvents.cast(this).getScrollType().toPublic();
    }

    default public float deltaX() {
        return MouseEvents.cast(this).getDeltaX();
    }

    default public float deltaY() {
        return MouseEvents.cast(this).getDeltaY();
    }

    public static final class Builder {
        private final MouseWheel.Builder builder;

        private Builder(Point location) {
            this.builder = com.teamdev.jxbrowser.ui.event.internal.rpc.MouseWheel.newBuilder().setLocation((com.teamdev.jxbrowser.ui.internal.rpc.Point)location);
        }

        public Builder locationOnScreen(Point locationOnScreen) {
            Preconditions.checkNotNull(locationOnScreen);
            this.builder.setLocationOnScreen((com.teamdev.jxbrowser.ui.internal.rpc.Point)locationOnScreen);
            return this;
        }

        public Builder keyModifiers(KeyModifiers keyModifiers) {
            Preconditions.checkNotNull(keyModifiers);
            this.builder.setKeyModifiers((com.teamdev.jxbrowser.ui.event.internal.rpc.KeyModifiers)keyModifiers);
            return this;
        }

        public Builder scrollType(ScrollType scrollType) {
            Preconditions.checkNotNull(scrollType);
            this.builder.setScrollType(com.teamdev.jxbrowser.ui.internal.rpc.ScrollType.fromPublic(scrollType));
            return this;
        }

        public Builder deltaX(float deltaX) {
            this.builder.setDeltaX(deltaX);
            return this;
        }

        public Builder deltaY(float deltaY) {
            this.builder.setDeltaY(deltaY);
            return this;
        }

        public MouseWheel build() {
            return this.builder.build();
        }
    }
}

