/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.graphics;

import com.teamdev.jxbrowser.internal.Lazy;
import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.ui.Bitmap;

public abstract class BitmapImage<I> {
    private final Bitmap bitmap;
    private final Lazy<I> image;

    protected BitmapImage(Bitmap bitmap) {
        Preconditions.checkNotNull(bitmap);
        Preconditions.checkArgument(!bitmap.size().isEmpty(), "Bitmap size cannot be empty", new Object[0]);
        this.bitmap = bitmap;
        this.image = new Lazy<Object>(this::createImage);
    }

    protected abstract I createImage();

    protected final Bitmap bitmap() {
        return this.bitmap;
    }

    public final I toolkitImage() {
        return this.image.get();
    }
}

