/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.compose.internal.dnd;

import androidx.compose.foundation.draganddrop.DragAndDropSourceScope;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.draganddrop.DragAndDropTransferAction;
import androidx.compose.ui.draganddrop.DragAndDropTransferData;
import androidx.compose.ui.draganddrop.DragAndDropTransferable;
import androidx.compose.ui.draganddrop.DragAndDrop_desktopKt;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.graphics.ImageBitmap;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.unit.Density;
import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.browser.internal.DragAndDrop;
import com.teamdev.jxbrowser.browser.internal.callback.StartDragCallback;
import com.teamdev.jxbrowser.browser.internal.rpc.DragOperation;
import com.teamdev.jxbrowser.browser.internal.rpc.DropData;
import com.teamdev.jxbrowser.browser.internal.rpc.StartDrag;
import com.teamdev.jxbrowser.callback.Advisable;
import com.teamdev.jxbrowser.callback.Callback;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.ui.internal.rpc.Bitmap;
import com.teamdev.jxbrowser.view.compose.internal.dnd.ChromiumDragHandlerKt;
import com.teamdev.jxbrowser.view.compose.internal.dnd.ChromiumTransferable;
import com.teamdev.jxbrowser.view.compose.internal.dnd.DragAction;
import com.teamdev.jxbrowser.view.compose.internal.dnd.DragAndDropContext;
import com.teamdev.jxbrowser.view.compose.internal.dnd.DragImage;
import com.teamdev.jxbrowser.view.compose.internal.render.ScalingKt;
import java.awt.datatransfer.Transferable;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u0018J\u0015\u0010\u001a\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0006\u001a\u00020\u001b\u00a2\u0006\u0002\u0010\u001cJ\u0017\u0010\u001d\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001e\u001a\u00020\u001fH\u0002\u00a2\u0006\u0002\u0010 J\u0010\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020#H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006$"}, d2={"Lcom/teamdev/jxbrowser/view/compose/internal/dnd/ChromiumDragHandler;", "", "widget", "Lcom/teamdev/jxbrowser/browser/internal/BrowserWidget;", "context", "Lcom/teamdev/jxbrowser/view/compose/internal/dnd/DragAndDropContext;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/teamdev/jxbrowser/browser/internal/BrowserWidget;Lcom/teamdev/jxbrowser/view/compose/internal/dnd/DragAndDropContext;Lkotlinx/coroutines/CoroutineScope;)V", "dnd", "Lcom/teamdev/jxbrowser/browser/internal/DragAndDrop;", "kotlin.jvm.PlatformType", "Lcom/teamdev/jxbrowser/browser/internal/DragAndDrop;", "supportedActions", "", "Landroidx/compose/ui/draganddrop/DragAndDropTransferAction;", "dragScope", "Landroidx/compose/foundation/draganddrop/DragAndDropSourceScope;", "getDragScope", "()Landroidx/compose/foundation/draganddrop/DragAndDropSourceScope;", "setDragScope", "(Landroidx/compose/foundation/draganddrop/DragAndDropSourceScope;)V", "start", "", "stop", "drawImage", "Landroidx/compose/ui/graphics/drawscope/DrawScope;", "(Landroidx/compose/ui/graphics/drawscope/DrawScope;)Lkotlin/Unit;", "startDrag", "dragAction", "Lcom/teamdev/jxbrowser/view/compose/internal/dnd/DragAction;", "(Lcom/teamdev/jxbrowser/view/compose/internal/dnd/DragAction;)Lkotlin/Unit;", "endDrag", "operation", "Lcom/teamdev/jxbrowser/browser/internal/rpc/DragOperation;", "compose"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nChromiumDragHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChromiumDragHandler.kt\ncom/teamdev/jxbrowser/view/compose/internal/dnd/ChromiumDragHandler\n+ 2 Async.kt\ncom/teamdev/jxbrowser/dsl/AsyncKt\n*L\n1#1,134:1\n44#2:135\n61#2:136\n*S KotlinDebug\n*F\n+ 1 ChromiumDragHandler.kt\ncom/teamdev/jxbrowser/view/compose/internal/dnd/ChromiumDragHandler\n*L\n65#1:135\n83#1:136\n*E\n"})
public final class ChromiumDragHandler {
    @NotNull
    private final BrowserWidget widget;
    @NotNull
    private final DragAndDropContext context;
    @NotNull
    private final CoroutineScope scope;
    private final DragAndDrop dnd;
    @NotNull
    private final List<DragAndDropTransferAction> supportedActions;
    @Nullable
    private DragAndDropSourceScope dragScope;
    public static final int $stable = 8;

    public ChromiumDragHandler(@NotNull BrowserWidget widget, @NotNull DragAndDropContext context, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)widget, (String)"widget");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.widget = widget;
        this.context = context;
        this.scope = scope;
        this.dnd = this.widget.browser().dragAndDrop();
        Object[] objectArray = new DragAndDropTransferAction[]{DragAndDropTransferAction.Companion.getCopy(), DragAndDropTransferAction.Companion.getMove(), DragAndDropTransferAction.Companion.getLink()};
        this.supportedActions = CollectionsKt.listOf((Object[])objectArray);
    }

    @Nullable
    public final DragAndDropSourceScope getDragScope() {
        return this.dragScope;
    }

    public final void setDragScope(@Nullable DragAndDropSourceScope dragAndDropSourceScope) {
        this.dragScope = dragAndDropSourceScope;
    }

    /*
     * WARNING - void declaration
     */
    public final void start() {
        void $this$register$iv;
        DragAndDrop dragAndDrop = this.dnd;
        Intrinsics.checkNotNullExpressionValue((Object)dragAndDrop, (String)"dnd");
        Advisable advisable = (Advisable)dragAndDrop;
        Callback callback$iv = (Callback)((StartDragCallback)arg_0 -> ChromiumDragHandler.start$lambda$1(this, arg_0));
        boolean $i$f$register = false;
        $this$register$iv.set(StartDragCallback.class, callback$iv);
    }

    public final void stop() {
        DragAndDrop dragAndDrop = this.dnd;
        Intrinsics.checkNotNullExpressionValue((Object)dragAndDrop, (String)"dnd");
        Advisable $this$removeCallback$iv = (Advisable)dragAndDrop;
        boolean $i$f$removeCallback = false;
        $this$removeCallback$iv.remove(StartDragCallback.class);
    }

    @Nullable
    public final Unit drawImage(@NotNull DrawScope scope) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Object object = this.context.getDragAction();
        if (object != null && (object = ((DragAction)object).getDragImage()) != null) {
            Object it = object;
            boolean bl = false;
            DrawScope.drawImage-gbVJVH8$default((DrawScope)scope, (ImageBitmap)((DragImage)it).getImage(), (long)0L, (float)0.0f, null, null, (int)0, (int)62, null);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    private final Unit startDrag(DragAction dragAction) {
        Unit unit;
        DragAndDropSourceScope dragAndDropSourceScope = this.dragScope;
        if (dragAndDropSourceScope != null) {
            long l;
            DragAndDropSourceScope dragScope = dragAndDropSourceScope;
            boolean bl = false;
            ChromiumTransferable transferable = new ChromiumTransferable(dragAction.getDropData());
            DragImage dragImage = dragAction.getDragImage();
            if (dragImage != null) {
                DragImage image = dragImage;
                boolean bl2 = false;
                l = Environment.isMac() ? ScalingKt.scaledUp-3MmeM6k(image.getOffset-F1C5BW0(), (Density)dragScope) : image.getOffset-F1C5BW0();
            } else {
                l = Offset.Companion.getZero-F1C5BW0();
            }
            long offset = l;
            DragAndDropTransferable dragAndDropTransferable = DragAndDrop_desktopKt.DragAndDropTransferable((Transferable)transferable);
            List<DragAndDropTransferAction> list = this.supportedActions;
            dragScope.startTransfer(new DragAndDropTransferData(dragAndDropTransferable, (Iterable)list, offset, arg_0 -> ChromiumDragHandler.startDrag$lambda$5$lambda$4(this, arg_0), null));
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    private final void endDrag(DragOperation operation) {
        this.widget.dragEnd(Point.empty(), Point.empty(), operation);
        this.context.setDragAction(null);
    }

    private static final StartDrag.Response start$lambda$1(ChromiumDragHandler this$0, StartDrag.Request params) {
        DragImage dragImage;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        DropData dropData = params.getDropData();
        StartDrag.Request $this$start_u24lambda_u241_u24lambda_u240 = params;
        boolean bl = false;
        if (!$this$start_u24lambda_u241_u24lambda_u240.getDragImage().getSize().isEmpty()) {
            com.teamdev.jxbrowser.ui.internal.rpc.Point point = $this$start_u24lambda_u241_u24lambda_u240.getDragImageOffset();
            Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getDragImageOffset(...)");
            Bitmap bitmap = $this$start_u24lambda_u241_u24lambda_u240.getDragImage();
            Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"getDragImage(...)");
            dragImage = new DragImage(point, bitmap);
        } else {
            dragImage = null;
        }
        DragImage dragImage2 = dragImage;
        Intrinsics.checkNotNull((Object)dropData);
        DragAction dragAction = new DragAction(dropData, dragImage2);
        BuildersKt.launch$default((CoroutineScope)this$0.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, dragAction, null){
            int label;
            final /* synthetic */ ChromiumDragHandler this$0;
            final /* synthetic */ DragAction $dragAction;
            {
                this.this$0 = $receiver;
                this.$dragAction = $dragAction;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        ChromiumDragHandler.access$getContext$p(this.this$0).setDragAction(this.$dragAction);
                        ChromiumDragHandler.access$startDrag(this.this$0, this.$dragAction);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        return StartDrag.Response.newBuilder().build();
    }

    private static final Unit startDrag$lambda$5$lambda$4(ChromiumDragHandler this$0, DragAndDropTransferAction it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.endDrag(ChromiumDragHandlerKt.access$toProtoOperation(it));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ DragAndDropContext access$getContext$p(ChromiumDragHandler $this) {
        return $this.context;
    }

    public static final /* synthetic */ Unit access$startDrag(ChromiumDragHandler $this, DragAction dragAction) {
        return $this.startDrag(dragAction);
    }
}

