/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.compose.internal.dnd;

import androidx.compose.runtime.internal.StabilityInferred;
import com.teamdev.jxbrowser.browser.internal.rpc.DropData;
import com.teamdev.jxbrowser.deps.com.google.protobuf.ByteString;
import com.teamdev.jxbrowser.deps.com.google.protobuf.ProtocolStringList;
import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.view.compose.internal.dnd.CustomDataEnvelope;
import com.teamdev.jxbrowser.view.compose.internal.dnd.CustomDataSupport;
import com.teamdev.jxbrowser.view.compose.internal.dnd.CustomDataType;
import com.teamdev.jxbrowser.view.compose.internal.dnd.MacOsCompatibility;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0001\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0013\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bH\u0016J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\bH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J!\u0010\u0016\u001a\u0004\u0018\u00010\u00122\b\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0017\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/teamdev/jxbrowser/view/compose/internal/dnd/ChromiumTransferable;", "Ljava/awt/datatransfer/Transferable;", "dropData", "Lcom/teamdev/jxbrowser/browser/internal/rpc/DropData;", "<init>", "(Lcom/teamdev/jxbrowser/browser/internal/rpc/DropData;)V", "data", "Ljava/util/HashMap;", "Ljava/awt/datatransfer/DataFlavor;", "", "getTransferDataFlavors", "", "()[Ljava/awt/datatransfer/DataFlavor;", "isDataFlavorSupported", "", "flavor", "getTransferData", "addUrl", "", "addHtml", "addText", "addCustom", "addData", "transferData", "(Ljava/awt/datatransfer/DataFlavor;Ljava/lang/Object;)Lkotlin/Unit;", "shouldNotIgnore", "baseUrl", "", "Companion", "compose"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nChromiumTransferable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChromiumTransferable.kt\ncom/teamdev/jxbrowser/view/compose/internal/dnd/ChromiumTransferable\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,125:1\n37#2,2:126\n*S KotlinDebug\n*F\n+ 1 ChromiumTransferable.kt\ncom/teamdev/jxbrowser/view/compose/internal/dnd/ChromiumTransferable\n*L\n57#1:126,2\n*E\n"})
public final class ChromiumTransferable
implements Transferable {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final HashMap<DataFlavor, Object> data;
    public static final int $stable = 8;
    @NotNull
    private static final DataFlavor HTML_FLAVOR;
    @NotNull
    private static final DataFlavor JAVA_STRING_FLAVOR;
    @NotNull
    private static final DataFlavor X_MOZ_URL_FLAVOR;
    @Nullable
    private static final DataFlavor JAVA_URL_FLAVOR;
    @Nullable
    private static final DataFlavor URI_LIST_FLAVOR;
    @Nullable
    private static final DataFlavor PLAIN_TEXT_FLAVOR;
    @Deprecated
    @NotNull
    public static final String ABOUT_BLANK_BLOCKED = "about:blank#blocked";

    public ChromiumTransferable(@NotNull DropData dropData) {
        Intrinsics.checkNotNullParameter((Object)dropData, (String)"dropData");
        this.data = new HashMap();
        this.addUrl(dropData);
        this.addHtml(dropData);
        this.addText(dropData);
        this.addCustom(dropData);
    }

    @Override
    @NotNull
    public DataFlavor[] getTransferDataFlavors() {
        Set<DataFlavor> set = this.data.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        Collection $this$toTypedArray$iv = set;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new DataFlavor[0]);
    }

    @Override
    public boolean isDataFlavorSupported(@NotNull DataFlavor flavor) {
        Intrinsics.checkNotNullParameter((Object)flavor, (String)"flavor");
        return this.data.containsKey(flavor);
    }

    @Override
    @NotNull
    public Object getTransferData(@NotNull DataFlavor flavor) {
        Intrinsics.checkNotNullParameter((Object)flavor, (String)"flavor");
        Object object = this.data.get(flavor);
        if (object == null) {
            throw new UnsupportedFlavorException(flavor);
        }
        return object;
    }

    private final void addUrl(DropData dropData) {
        String url = dropData.getUrl();
        Intrinsics.checkNotNull((Object)url);
        if (((CharSequence)url).length() > 0) {
            this.addData(JAVA_URL_FLAVOR, url);
            this.addData(PLAIN_TEXT_FLAVOR, url);
            this.addData(JAVA_STRING_FLAVOR, url);
            if (Environment.isLinux()) {
                this.addData(X_MOZ_URL_FLAVOR, url);
                v0 = this.addData(URI_LIST_FLAVOR, url);
            } else {
                v0 = Environment.isMac() ? this.addData(MacOsCompatibility.INSTANCE.getSERIALIZED_URL_FLAVOR(), MacOsCompatibility.INSTANCE.serializeUrlForPasteboard(url)) : this.addData(URI_LIST_FLAVOR, url);
            }
        }
    }

    private final void addHtml(DropData dropData) {
        block3: {
            String html;
            block2: {
                html = dropData.getHtml();
                String htmlBaseUrl = dropData.getHtmlBaseUrl();
                Intrinsics.checkNotNull((Object)htmlBaseUrl);
                if (this.shouldNotIgnore(htmlBaseUrl)) break block2;
                Intrinsics.checkNotNull((Object)html);
                if (!(((CharSequence)html).length() > 0)) break block3;
            }
            Intrinsics.checkNotNull((Object)html);
            this.addData(HTML_FLAVOR, html);
        }
    }

    private final void addText(DropData dropData) {
        String text = dropData.getText();
        Intrinsics.checkNotNull((Object)text);
        if (((CharSequence)text).length() > 0) {
            this.addData(PLAIN_TEXT_FLAVOR, text);
            this.addData(JAVA_STRING_FLAVOR, text);
        }
    }

    private final void addCustom(DropData dropData) {
        ByteString customData = dropData.getCustomData().getAsBytes();
        if (!customData.isEmpty()) {
            DataFlavor dataFlavor = CustomDataSupport.INSTANCE.getRAW_CUSTOM_DATA();
            byte[] byArray = customData.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
            this.addData(dataFlavor, byArray);
            DataFlavor dataFlavor2 = CustomDataSupport.INSTANCE.getENVELOPED_CUSTOM_DATA();
            byte[] byArray2 = customData.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"toByteArray(...)");
            this.addData(dataFlavor2, new CustomDataEnvelope(byArray2));
            ProtocolStringList protocolStringList = dropData.getCustomData().getTypesList();
            Intrinsics.checkNotNullExpressionValue((Object)protocolStringList, (String)"getTypesList(...)");
            List entries = CollectionsKt.toList((Iterable)((Iterable)protocolStringList));
            this.addData(CustomDataType.Companion.getCUSTOM_DATA_FLAVOR(), entries);
        }
    }

    private final Unit addData(DataFlavor flavor, Object transferData) {
        Unit unit;
        DataFlavor dataFlavor = flavor;
        if (dataFlavor != null) {
            DataFlavor it = dataFlavor;
            boolean bl = false;
            ((Map)this.data).put(flavor, transferData);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    private final boolean shouldNotIgnore(String baseUrl) {
        return ((CharSequence)baseUrl).length() > 0 && !Intrinsics.areEqual((Object)baseUrl, (Object)ABOUT_BLANK_BLOCKED);
    }

    static {
        DataFlavor dataFlavor = DataFlavor.fragmentHtmlFlavor;
        Intrinsics.checkNotNullExpressionValue((Object)dataFlavor, (String)"fragmentHtmlFlavor");
        HTML_FLAVOR = dataFlavor;
        DataFlavor dataFlavor2 = DataFlavor.stringFlavor;
        Intrinsics.checkNotNullExpressionValue((Object)dataFlavor2, (String)"stringFlavor");
        JAVA_STRING_FLAVOR = dataFlavor2;
        X_MOZ_URL_FLAVOR = new DataFlavor("text/x-moz-url", "URL");
        JAVA_URL_FLAVOR = Companion.stringFlavor("application/x-java-url", "URL");
        URI_LIST_FLAVOR = Companion.stringFlavor("text/uri-list", "URI list");
        PLAIN_TEXT_FLAVOR = Companion.stringFlavor("text/plain", "Plain text");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0014\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0013\u0010\f\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007R\u000e\u0010\u0012\u001a\u00020\u0013X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/teamdev/jxbrowser/view/compose/internal/dnd/ChromiumTransferable$Companion;", "", "<init>", "()V", "HTML_FLAVOR", "Ljava/awt/datatransfer/DataFlavor;", "getHTML_FLAVOR", "()Ljava/awt/datatransfer/DataFlavor;", "JAVA_STRING_FLAVOR", "getJAVA_STRING_FLAVOR", "X_MOZ_URL_FLAVOR", "getX_MOZ_URL_FLAVOR", "JAVA_URL_FLAVOR", "getJAVA_URL_FLAVOR", "URI_LIST_FLAVOR", "getURI_LIST_FLAVOR", "PLAIN_TEXT_FLAVOR", "getPLAIN_TEXT_FLAVOR", "ABOUT_BLANK_BLOCKED", "", "stringFlavor", "mimeType", "name", "compose"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataFlavor getHTML_FLAVOR() {
            return HTML_FLAVOR;
        }

        @NotNull
        public final DataFlavor getJAVA_STRING_FLAVOR() {
            return JAVA_STRING_FLAVOR;
        }

        @NotNull
        public final DataFlavor getX_MOZ_URL_FLAVOR() {
            return X_MOZ_URL_FLAVOR;
        }

        @Nullable
        public final DataFlavor getJAVA_URL_FLAVOR() {
            return JAVA_URL_FLAVOR;
        }

        @Nullable
        public final DataFlavor getURI_LIST_FLAVOR() {
            return URI_LIST_FLAVOR;
        }

        @Nullable
        public final DataFlavor getPLAIN_TEXT_FLAVOR() {
            return PLAIN_TEXT_FLAVOR;
        }

        @Nullable
        public final DataFlavor stringFlavor(@NotNull String mimeType, @NotNull String name) {
            DataFlavor dataFlavor;
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            try {
                dataFlavor = new DataFlavor(mimeType + "; class=java.lang.String; charset=Unicode", name);
            }
            catch (IllegalArgumentException e) {
                Logger.warn((String)("Failed to create a data flavor for the type: " + mimeType), (Throwable)e);
                dataFlavor = null;
            }
            return dataFlavor;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

