/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.compose.internal.dnd;

import androidx.compose.runtime.internal.StabilityInferred;
import com.teamdev.jxbrowser.view.compose.internal.dnd.CustomDataEnvelope;
import com.teamdev.jxbrowser.view.internal.CustomDataMimeType;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorMap;
import java.awt.datatransfer.SystemFlavorMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c1\u0002\u0018\u00002\u00020\u0001B\t\b\u0003\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\tR\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lcom/teamdev/jxbrowser/view/compose/internal/dnd/CustomDataSupport;", "", "<init>", "()V", "CUSTOM_FORMAT", "Lcom/teamdev/jxbrowser/view/internal/CustomDataMimeType;", "kotlin.jvm.PlatformType", "Lcom/teamdev/jxbrowser/view/internal/CustomDataMimeType;", "RAW_CUSTOM_DATA", "Ljava/awt/datatransfer/DataFlavor;", "getRAW_CUSTOM_DATA", "()Ljava/awt/datatransfer/DataFlavor;", "ENVELOPED_CUSTOM_DATA", "getENVELOPED_CUSTOM_DATA", "configureFlavorMap", "", "isCustomDataFlavor", "", "flavor", "compose"})
@StabilityInferred(parameters=0)
public final class CustomDataSupport {
    @NotNull
    public static final CustomDataSupport INSTANCE = new CustomDataSupport();
    private static final CustomDataMimeType CUSTOM_FORMAT = CustomDataMimeType.forCurrentPlatform();
    @NotNull
    private static final DataFlavor RAW_CUSTOM_DATA = new DataFlavor(byte[].class, "Chromium Custom Drop Data");
    @NotNull
    private static final DataFlavor ENVELOPED_CUSTOM_DATA = new DataFlavor(CustomDataEnvelope.class, "Enveloped Chromium Custom Drop Data");
    public static final int $stable = 8;

    private CustomDataSupport() {
    }

    @NotNull
    public final DataFlavor getRAW_CUSTOM_DATA() {
        return RAW_CUSTOM_DATA;
    }

    @NotNull
    public final DataFlavor getENVELOPED_CUSTOM_DATA() {
        return ENVELOPED_CUSTOM_DATA;
    }

    public final void configureFlavorMap() {
        FlavorMap flavorMap = SystemFlavorMap.getDefaultFlavorMap();
        Intrinsics.checkNotNull((Object)flavorMap, (String)"null cannot be cast to non-null type java.awt.datatransfer.SystemFlavorMap");
        SystemFlavorMap flavorMap2 = (SystemFlavorMap)flavorMap;
        Object[] objectArray = new DataFlavor[]{RAW_CUSTOM_DATA};
        flavorMap2.setFlavorsForNative(CUSTOM_FORMAT.value(), (DataFlavor[])objectArray);
        objectArray = new String[]{CUSTOM_FORMAT.value()};
        flavorMap2.setNativesForFlavor(RAW_CUSTOM_DATA, (String[])objectArray);
    }

    public final boolean isCustomDataFlavor(@NotNull DataFlavor flavor) {
        Intrinsics.checkNotNullParameter((Object)flavor, (String)"flavor");
        String name = flavor.getHumanPresentableName();
        String rawDataName = RAW_CUSTOM_DATA.getHumanPresentableName();
        String envelopedDataName = ENVELOPED_CUSTOM_DATA.getHumanPresentableName();
        return Intrinsics.areEqual((Object)rawDataName, (Object)name) || Intrinsics.areEqual((Object)envelopedDataName, (Object)name);
    }
}

