/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.compose.internal.dnd;

import androidx.compose.runtime.internal.StabilityInferred;
import com.teamdev.jxbrowser.browser.internal.rpc.DropData;
import com.teamdev.jxbrowser.browser.internal.rpc.DropMetadata;
import com.teamdev.jxbrowser.deps.com.google.protobuf.ByteString;
import com.teamdev.jxbrowser.internal.MacPasteboard;
import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.view.compose.internal.dnd.CustomDataEnvelope;
import com.teamdev.jxbrowser.view.compose.internal.dnd.CustomDataSupport;
import com.teamdev.jxbrowser.view.compose.internal.dnd.DataType;
import com.teamdev.jxbrowser.view.compose.internal.dnd.RichDataFlavor;
import com.teamdev.jxbrowser.view.internal.CustomTypeMimeType;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0001\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\t\b\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\f\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0012\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u0011H\u0014J\u001d\u0010\u0013\u001a\n \u0015*\u0004\u0018\u00010\u00140\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u00a2\u0006\u0002\u0010\u0018J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00172\u0006\u0010\b\u001a\u00020\tH\u0002J\n\u0010\u001a\u001a\u0004\u0018\u00010\u0017H\u0002J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00112\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u001e"}, d2={"Lcom/teamdev/jxbrowser/view/compose/internal/dnd/CustomDataType;", "Lcom/teamdev/jxbrowser/view/compose/internal/dnd/DataType;", "<init>", "()V", "fillDropData", "", "dropData", "Lcom/teamdev/jxbrowser/browser/internal/rpc/DropData$Builder;", "transferable", "Ljava/awt/datatransfer/Transferable;", "isPresentedIn", "", "fillMetadata", "metadata", "Lcom/teamdev/jxbrowser/browser/internal/rpc/DropMetadata$Builder;", "", "supportedFlavors", "", "Lcom/teamdev/jxbrowser/view/compose/internal/dnd/RichDataFlavor;", "wrap", "Lcom/teamdev/jxbrowser/browser/internal/rpc/DropData$CustomData;", "kotlin.jvm.PlatformType", "data", "Lcom/teamdev/jxbrowser/deps/com/google/protobuf/ByteString;", "(Lcom/google/protobuf/ByteString;)Lcom/teamdev/jxbrowser/browser/internal/rpc/DropData$CustomData;", "customData", "readFromPasteboard", "findCustomTypes", "", "Companion", "compose"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nCustomDataType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomDataType.kt\ncom/teamdev/jxbrowser/view/compose/internal/dnd/CustomDataType\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n12511#2,2:92\n1863#3,2:94\n*S KotlinDebug\n*F\n+ 1 CustomDataType.kt\ncom/teamdev/jxbrowser/view/compose/internal/dnd/CustomDataType\n*L\n42#1:92,2\n45#1:94,2\n*E\n"})
public final class CustomDataType
extends DataType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;
    @NotNull
    private static final DataFlavor CUSTOM_DATA_FLAVOR;

    @Override
    public void fillDropData(@NotNull DropData.Builder dropData, @NotNull Transferable transferable) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)dropData, (String)"dropData");
            Intrinsics.checkNotNullParameter((Object)transferable, (String)"transferable");
            ByteString byteString = this.customData(transferable);
            if (byteString == null) break block0;
            ByteString byteString2 = byteString;
            boolean bl = false;
            DropData.CustomData data = this.wrap(byteString2);
            dropData.setCustomData(data);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isPresentedIn(@NotNull Transferable transferable) {
        boolean bl;
        block1: {
            void $this$any$iv;
            Intrinsics.checkNotNullParameter((Object)transferable, (String)"transferable");
            DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
            Intrinsics.checkNotNullExpressionValue((Object)dataFlavorArray, (String)"getTransferDataFlavors(...)");
            Object[] objectArray = dataFlavorArray;
            CustomDataSupport customDataSupport = CustomDataSupport.INSTANCE;
            boolean $i$f$any = false;
            for (void element$iv : $this$any$iv) {
                DataFlavor p0 = (DataFlavor)element$iv;
                boolean bl2 = false;
                if (!customDataSupport.isCustomDataFlavor(p0)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    public void fillMetadata(@NotNull DropMetadata.Builder metadata, @NotNull Transferable transferable) {
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        Intrinsics.checkNotNullParameter((Object)transferable, (String)"transferable");
        Iterable $this$forEach$iv = this.findCustomTypes(transferable);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String p0 = (String)element$iv;
            boolean bl = false;
            metadata.addCustomDataTypes(p0);
        }
    }

    @NotNull
    protected Void fillMetadata(@NotNull DropMetadata.Builder metadata) {
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    protected List<RichDataFlavor<?>> supportedFlavors() {
        return CollectionsKt.emptyList();
    }

    private final DropData.CustomData wrap(ByteString data) {
        return DropData.CustomData.newBuilder().setAsBytes(data).build();
    }

    private final ByteString customData(Transferable transferable) {
        ByteString byteString;
        if (transferable.isDataFlavorSupported(CustomDataSupport.INSTANCE.getENVELOPED_CUSTOM_DATA())) {
            Object object = transferable.getTransferData(CustomDataSupport.INSTANCE.getENVELOPED_CUSTOM_DATA());
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.teamdev.jxbrowser.view.compose.internal.dnd.CustomDataEnvelope");
            CustomDataEnvelope data = (CustomDataEnvelope)object;
            byteString = data.bytesString();
        } else if (transferable.isDataFlavorSupported(CustomDataSupport.INSTANCE.getRAW_CUSTOM_DATA())) {
            Object object = transferable.getTransferData(CustomDataSupport.INSTANCE.getRAW_CUSTOM_DATA());
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.ByteArray");
            byte[] data = (byte[])object;
            byteString = ByteString.copyFrom((byte[])data);
        } else {
            byteString = Environment.isMac() ? this.readFromPasteboard() : null;
        }
        return byteString;
    }

    private final ByteString readFromPasteboard() {
        byte[] data = MacPasteboard.instance().readCustomData();
        Intrinsics.checkNotNull((Object)data);
        return !(data.length == 0) ? ByteString.copyFrom((byte[])data) : null;
    }

    private final List<String> findCustomTypes(Transferable transferable) {
        try {
            String string = CUSTOM_DATA_FLAVOR.getHumanPresentableName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHumanPresentableName(...)");
            String flavorName = string;
            Iterator iterator = ArrayIteratorKt.iterator((Object[])transferable.getTransferDataFlavors());
            while (iterator.hasNext()) {
                DataFlavor flavor = (DataFlavor)iterator.next();
                if (!Intrinsics.areEqual((Object)flavorName, (Object)flavor.getHumanPresentableName())) continue;
                Object object = transferable.getTransferData(flavor);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
                return (List)object;
            }
        }
        catch (UnsupportedFlavorException e) {
            Logger.warn((Throwable)e, CustomDataType::findCustomTypes$lambda$1);
        }
        catch (IOException e) {
            Logger.warn((Throwable)e, CustomDataType::findCustomTypes$lambda$2);
        }
        return CollectionsKt.emptyList();
    }

    private static final String findCustomTypes$lambda$1() {
        return "Failed to read custom data types from the drag board";
    }

    private static final String findCustomTypes$lambda$2() {
        return "Failed to read custom data types from the drag board";
    }

    static {
        CUSTOM_DATA_FLAVOR = new DataFlavor(CustomTypeMimeType.value(), "Chromium Custom Data Types");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/teamdev/jxbrowser/view/compose/internal/dnd/CustomDataType$Companion;", "", "<init>", "()V", "CUSTOM_DATA_FLAVOR", "Ljava/awt/datatransfer/DataFlavor;", "getCUSTOM_DATA_FLAVOR", "()Ljava/awt/datatransfer/DataFlavor;", "compose"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataFlavor getCUSTOM_DATA_FLAVOR() {
            return CUSTOM_DATA_FLAVOR;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

