/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.compose.internal.dnd;

import androidx.compose.runtime.internal.StabilityInferred;
import com.teamdev.jxbrowser.browser.internal.rpc.DropData;
import com.teamdev.jxbrowser.browser.internal.rpc.DropMetadata;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.view.compose.internal.dnd.DataType;
import com.teamdev.jxbrowser.view.compose.internal.dnd.DistortedUtf;
import com.teamdev.jxbrowser.view.compose.internal.dnd.MimeType;
import com.teamdev.jxbrowser.view.compose.internal.dnd.StringDataFlavor;
import com.teamdev.jxbrowser.view.compose.internal.dnd.WindowsHtmlClipboardFormat;
import java.awt.datatransfer.Transferable;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0001\u0018\u00002\u00020\u0001B\t\b\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/teamdev/jxbrowser/view/compose/internal/dnd/HtmlDataType;", "Lcom/teamdev/jxbrowser/view/compose/internal/dnd/DataType;", "<init>", "()V", "htmlFlavor", "Lcom/teamdev/jxbrowser/view/compose/internal/dnd/StringDataFlavor;", "fillDropData", "", "dropData", "Lcom/teamdev/jxbrowser/browser/internal/rpc/DropData$Builder;", "transferable", "Ljava/awt/datatransfer/Transferable;", "fillMetadata", "metadata", "Lcom/teamdev/jxbrowser/browser/internal/rpc/DropMetadata$Builder;", "supportedFlavors", "", "compose"})
@StabilityInferred(parameters=0)
public final class HtmlDataType
extends DataType {
    @NotNull
    private final StringDataFlavor htmlFlavor = new StringDataFlavor(new MimeType("text/html"), null, 2, null);
    public static final int $stable = 8;

    @Override
    public void fillDropData(@NotNull DropData.Builder dropData, @NotNull Transferable transferable) {
        Intrinsics.checkNotNullParameter((Object)dropData, (String)"dropData");
        Intrinsics.checkNotNullParameter((Object)transferable, (String)"transferable");
        if (!this.isPresentedIn(transferable)) {
            return;
        }
        String html = this.htmlFlavor.read(transferable);
        if (Environment.isWindows()) {
            html = WindowsHtmlClipboardFormat.INSTANCE.removeMetaData(html);
        }
        if (Environment.isLinux()) {
            html = DistortedUtf.INSTANCE.truncateBom(html);
            html = DistortedUtf.INSTANCE.removeZeros(html);
        }
        dropData.setHtml(html);
    }

    @Override
    protected void fillMetadata(@NotNull DropMetadata.Builder metadata) {
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        metadata.setContainsHtml(true);
    }

    @NotNull
    protected List<StringDataFlavor> supportedFlavors() {
        return CollectionsKt.listOf((Object)this.htmlFlavor);
    }
}

